/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.solr;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.ow2.weblab.services.indexer.impl.SolrIndexerConfig;
import org.ow2.weblab.services.searcher.impl.SolrSearcherConfig;
import org.ow2.weblab.util.index.Field;
import org.ow2.weblab.util.index.IndexerConfig;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.exception.WebLabUncheckedException;
import org.weblab_project.core.helper.BeanHelper;
import org.weblab_project.core.helper.RDFHelperFactory;
import org.weblab_project.core.helper.ResourceHelper;
import org.weblab_project.core.model.ComposedUnit;
import org.weblab_project.core.model.Resource;
import org.weblab_project.core.model.text.Text;
import org.weblab_project.core.util.ComposedUnitUtil;
import org.xml.sax.SAXException;

public class SolrComponent {
    private static SolrComponent singleton;
    public static final String SPRING_INDEX_CONF = "IndexerBean.xml";
    public static final String DEFAULT_HOME = "/solr";
    public static final int MINI_TEXT_SIZE = 3;
    public static final int BUFFER_DEFAULT_SIZE = 50;
    private SolrIndexerConfig indexerConfig;
    private SolrSearcherConfig searcherConfig;
    private EmbeddedSolrServer server;
    private int bufferSize;
    private volatile int docInBufferCounter = 0;
    private static final SimpleDateFormat solrFormat;

    public static synchronized SolrComponent getInstance(String springConfFile, String beanName) {
        if (singleton == null) {
            singleton = new SolrComponent(springConfFile, beanName);
        }
        return singleton;
    }

    public static SolrComponent getInstance() {
        return SolrComponent.getInstance(SPRING_INDEX_CONF, IndexerConfig.DEFAULT_BEAN_NAME);
    }

    private SolrComponent(String springConfFile, String beanName) {
        this.indexerConfig = (SolrIndexerConfig)BeanHelper.getInstance().getSpecificInstance(springConfFile, true).getBean(beanName, SolrIndexerConfig.class);
        this.searcherConfig = (SolrSearcherConfig)BeanHelper.getInstance().getSpecificInstance("SearcherBean.xml", true).getBean("SearcherConfig", SolrSearcherConfig.class);
        this.bufferSize = this.indexerConfig.getMinBufferSize() != 0 ? this.indexerConfig.getMinBufferSize() : 50;
    }

    public void open(String appPath) {
        this.open(appPath, this.indexerConfig.getSolrCoreName());
    }

    public synchronized void open(String appPath, String core) {
        if (this.server == null) {
            LogFactory.getLog(SolrComponent.class).info((Object)"Openning SOLR server...");
            File home = new File(appPath + DEFAULT_HOME);
            if (!home.exists() || !home.isDirectory()) {
                throw new WebLabUncheckedException("SOLR home [" + home + "]does not exists or is not a directory.");
            }
            File f = new File(home, "solr.xml");
            if (!f.exists() || f.isDirectory()) {
                throw new WebLabUncheckedException("SOLR core configuration file [" + f + "]does not exists or is a directory.");
            }
            CoreContainer container = new CoreContainer();
            try {
                container.load(appPath + DEFAULT_HOME, f);
            }
            catch (ParserConfigurationException e) {
                throw new WebLabUncheckedException("Cannot initialize the SOLR server due to erros in configuration file", (Throwable)e);
            }
            catch (IOException e) {
                throw new WebLabUncheckedException("Cannot initialize the SOLR server due to IO error", (Throwable)e);
            }
            catch (SAXException e) {
                throw new WebLabUncheckedException("Cannot initialize the SOLR server due to XML parser error", (Throwable)e);
            }
            this.server = new EmbeddedSolrServer(container, core);
            LogFactory.getLog(SolrComponent.class).info((Object)"SOLR server ready for battle.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Resource toBeIndexed) throws WebLabCheckedException {
        if (toBeIndexed == null) {
            throw new WebLabCheckedException("Input Document is null.");
        }
        LogFactory.getLog(this.getClass()).info((Object)("Indexing Resource [" + toBeIndexed.getUri() + "]..."));
        ResourceHelper helper = null;
        SolrInputDocument doc = new SolrInputDocument();
        try {
            new URI(toBeIndexed.getUri());
        }
        catch (URISyntaxException e) {
            throw new WebLabCheckedException("Resource to index does not have valid URI.", (Throwable)e);
        }
        doc.addField("id", (Object)toBeIndexed.getUri());
        for (Map.Entry<String, Field> entry : this.indexerConfig.getFields().entrySet()) {
            Field field = entry.getValue();
            String fieldName = field.getName();
            StringBuffer concatenationOfText = new StringBuffer();
            if (field.isIndexTextMediaUnit()) {
                concatenationOfText.append(SolrComponent.extractTextFromResource(toBeIndexed));
            }
            if (field.getProperties() != null && field.getProperties().size() > 0) {
                if (helper == null) {
                    helper = RDFHelperFactory.getResourceHelper((Resource)toBeIndexed);
                }
                ArrayList predList = new ArrayList();
                for (String property : field.getProperties()) {
                    predList.addAll(helper.getLitsOnPredSubj(toBeIndexed.getUri(), property));
                    predList.addAll(helper.getRessOnPredSubj(toBeIndexed.getUri(), property));
                }
                boolean maxNbOfDatesAchieved = false;
                for (String p : predList) {
                    if (field.getType().equals("date") && !maxNbOfDatesAchieved) {
                        try {
                            Date date = DateUtils.parseDate((String)p, (String[])IndexerConfig.DATE_FORMATS);
                            String solrDate = solrFormat.format(date);
                            concatenationOfText.append(solrDate);
                            maxNbOfDatesAchieved = true;
                        }
                        catch (ParseException pe) {
                            LogFactory.getLog(SolrComponent.class).debug((Object)("Unable to parse date : " + p));
                        }
                        continue;
                    }
                    concatenationOfText.append(p + "\n");
                }
            }
            if (concatenationOfText.length() <= 0) continue;
            doc.addField(fieldName, (Object)concatenationOfText.toString());
        }
        SolrComponent solrComponent = this;
        synchronized (solrComponent) {
            try {
                this.server.add(doc);
                ++this.docInBufferCounter;
                LogFactory.getLog(this.getClass()).info((Object)("Resource [" + toBeIndexed.getUri() + "] added to the indexing buffer."));
            }
            catch (IOException e) {
                throw new WebLabCheckedException("I/O access error when adding documents", (Throwable)e);
            }
            catch (SolrServerException e) {
                throw new WebLabCheckedException("Server error while adding documents", (Throwable)e);
            }
            if (this.docInBufferCounter >= this.bufferSize) {
                this.flushIndexBuffer();
            }
        }
    }

    public static String extractTextFromResource(Resource res) {
        Text t;
        StringBuffer concatenationOfText = new StringBuffer();
        if (res instanceof ComposedUnit) {
            List textList = ComposedUnitUtil.getSelectedSubMediaUnits((ComposedUnit)((ComposedUnit)res), Text.class);
            for (Text t2 : textList) {
                if (t2.getContent() == null || t2.getContent().length() <= 3) continue;
                concatenationOfText.append(t2.getContent().trim() + "\n");
            }
        } else if (res instanceof Text && (t = (Text)res).getContent() != null && t.getContent().length() > 3) {
            concatenationOfText.append(t.getContent().trim() + "\n");
        }
        return concatenationOfText.toString();
    }

    public synchronized void close() {
        try {
            LogFactory.getLog(this.getClass()).info((Object)"Closing SOLR server...");
            if (this.docInBufferCounter > 0) {
                this.flushIndexBuffer();
            }
        }
        catch (WebLabCheckedException e) {
            LogFactory.getLog(this.getClass()).error((Object)"Cannot flush the index indexing buffer properly.", (Throwable)e);
            throw new WebLabUncheckedException("Cannot flush the index indexing buffer properly.", (Throwable)e);
        }
        try {
            try {
                this.server.optimize();
            }
            catch (SolrServerException e) {
                throw new WebLabCheckedException("Server error while optimizing the index.", (Throwable)e);
            }
            catch (IOException e) {
                throw new WebLabCheckedException("I/O access error while optimizing the index.", (Throwable)e);
            }
            LogFactory.getLog(this.getClass()).info((Object)"SOLR server closed.");
        }
        catch (WebLabCheckedException e) {
            LogFactory.getLog(this.getClass()).warn((Object)"Cannot optimize the index properly.", (Throwable)e);
        }
    }

    public void flushIndexBuffer() throws WebLabCheckedException {
        try {
            this.server.commit();
            this.docInBufferCounter = 0;
            LogFactory.getLog(this.getClass()).info((Object)"Indexing buffer flushed.");
        }
        catch (SolrServerException e) {
            throw new WebLabCheckedException("Server error while adding documents", (Throwable)e);
        }
        catch (IOException e) {
            throw new WebLabCheckedException("I/O access error when adding documents", (Throwable)e);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public QueryResponse search(String queryString, int offset, int limit) throws WebLabCheckedException {
        QueryResponse response;
        if (!queryString.isEmpty()) {
            SolrQuery query = new SolrQuery();
            query.setQuery(queryString);
            query.setParam("start", new String[]{String.valueOf(offset)});
            query.setParam("rows", new String[]{String.valueOf(limit)});
            if (this.searcherConfig.isHitsEnrichedWithMetas()) {
                query.setParam("qt", new String[]{"weblab_with_meta"});
            } else {
                query.setParam("qt", new String[]{"weblab"});
            }
            try {
                response = this.server.query((SolrParams)query);
            }
            catch (SolrServerException sse) {
                LogFactory.getLog(this.getClass()).error((Object)"Cannot post search request", (Throwable)sse);
                throw new WebLabCheckedException("Cannot post search request", (Throwable)sse);
            }
        } else {
            response = new QueryResponse();
        }
        return response;
    }

    public QueryResponse moreLikeThis(String queryString) throws WebLabCheckedException {
        QueryResponse response;
        if (!queryString.isEmpty()) {
            SolrQuery query = new SolrQuery();
            query.setQueryType("mlt");
            query.set("mlt", new String[0]);
            query.set("mlt.match.include", false);
            query.set("mlt.mindf", 1);
            query.set("mlt.mintf", 1);
            query.set("mlt.fl", new String[]{"source,title,text"});
            query.setQuery(queryString);
            try {
                response = this.server.query((SolrParams)query);
            }
            catch (SolrServerException sse) {
                LogFactory.getLog(this.getClass()).error((Object)"Cannot post search request", (Throwable)sse);
                throw new WebLabCheckedException("Cannot post search request", (Throwable)sse);
            }
        } else {
            response = new QueryResponse();
        }
        return response;
    }

    static {
        solrFormat = new SimpleDateFormat("yyyy-MM-dd");
    }
}

