/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.util.index;

import java.util.List;

public class Field {

	/**
	 * Name of the field in the index
	 */
	protected String name;
	
	/**
	 * Field type : should be text, number, date
	 */
	protected String type;
	
	/**
	 * Indicate if the field contain MediaUnit text parts
	 */
	protected boolean indexTextMediaUnit;
	
	/**
	 * List of properties indexed in this field
	 */
	protected List<String> properties;

	/**
	 * @return the name
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the type
	 */
	public String getType() {
		return this.type;
	}

	/**
	 * @param type the type to set
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * @return the indexTextMediaUnit
	 */
	public boolean isIndexTextMediaUnit() {
		return this.indexTextMediaUnit;
	}

	/**
	 * @param indexTextMediaUnit the indexTextMediaUnit to set
	 */
	public void setIndexTextMediaUnit(boolean indexTextMediaUnit) {
		this.indexTextMediaUnit = indexTextMediaUnit;
	}

	/**
	 * @return the properties
	 */
	public List<String> getProperties() {
		return this.properties;
	}

	/**
	 * @param properties the properties to set
	 */
	public void setProperties(List<String> properties) {
		this.properties = properties;
	}
	
}
