/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.util.index;

import java.util.Map;


public class IndexerConfig {
	/**
	 * Common date format used for indexing and searching and some more stuff... This should be the format of dublin
	 * core dates.
	 */
	public static final String[] DATE_FORMATS = { "yyyy-MM-dd'T'hh:mm:ssZ", "yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd'T'hh:mm",
				"yyyy-MM-dd" };
	/**
	 * default name for indexer configuration bean
	 */
	public static String DEFAULT_BEAN_NAME = "IndexerBean";
	/**
	 * If the number of files in the buffer is small that <code>minBufferSize</code> nothing is commit.
	 */
	private int minBufferSize;
	/**
	 * Fields used by the index
	 */
	private Map<String, Field> fields;

	/**
	 * @return the minBufferSize
	 */
	public int getMinBufferSize() {
		return this.minBufferSize;
	}

	/**
	 * @param minBufferSize
	 *            the minBufferSize to set
	 */
	public void setMinBufferSize(int minBufferSize) {
		this.minBufferSize = minBufferSize;
	}

	/**
	 * @return the fields
	 */
	public Map<String, Field> getFields() {
		return this.fields;
	}

	/**
	 * @param fields
	 *            the fields to set
	 */
	public void setFields(Map<String, Field> fields) {
		this.fields = fields;
	}
}