/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.indexer.impl;

import java.io.File;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.services.solr.SolrComponent;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.model.MediaUnit;
import org.weblab_project.core.model.multimedia.BinaryMediaUnit;
import org.weblab_project.services.exception.WebLabException;
import org.weblab_project.services.indexer.IndexException;
import org.weblab_project.services.indexer.Indexer;
import org.weblab_project.services.indexer.types.IndexArgs;
import org.weblab_project.services.indexer.types.IndexReturn;

@WebService(endpointInterface="org.weblab_project.services.indexer.Indexer")
public class SolrIndexer
implements Indexer {
    @Resource
    protected WebServiceContext wsContext;
    private SolrComponent solr;

    @PostConstruct
    public void init() {
        this.solr = SolrComponent.getInstance();
    }

    public IndexReturn index(IndexArgs args) throws IndexException {
        MediaUnit unit = SolrIndexer.checkArgs(args);
        if (unit instanceof BinaryMediaUnit) {
            LogFactory.getLog(this.getClass()).warn((Object)("MediaUnit of type: " + unit.getClass().getSimpleName() + " cannot be indexed with Solr."));
            return new IndexReturn();
        }
        try {
            if (this.solr == null) {
                this.solr = SolrComponent.getInstance();
            }
            this.solr.open(this.getWebAppPath());
            this.solr.addDocument((org.weblab_project.core.model.Resource)unit);
        }
        catch (WebLabCheckedException e) {
            WebLabException excp = new WebLabException();
            excp.setErrorMessage("Cannot open Solr index : " + e.getMessage());
            throw new IndexException("Cannot open Solr index.", excp);
        }
        return new IndexReturn();
    }

    @PreDestroy
    public void destroy() {
        this.solr.close();
    }

    private String getWebAppPath() throws WebLabCheckedException {
        String appPath = "./src/main/resources";
        if (this.wsContext != null) {
            ServletContext ctx = (ServletContext)this.wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
            appPath = ctx.getRealPath("WEB-INF/classes");
        } else {
            LogFactory.getLog(SolrIndexer.class).warn((Object)"Webservice context not available returning current local path as default web app path");
        }
        File f = new File(appPath);
        if (!f.exists()) {
            throw new WebLabCheckedException("Webapp path [" + appPath + "] does not exists...");
        }
        return appPath;
    }

    private static MediaUnit checkArgs(IndexArgs args) throws IndexException {
        WebLabException wle = new WebLabException();
        wle.setErrorId("E1");
        wle.setErrorMessage("Invalid parameter");
        if (args == null) {
            LogFactory.getLog(SolrIndexer.class).error((Object)"IndexArgs was null.");
            throw new IndexException("IndexArgs was null.", wle);
        }
        if (args.getResource() == null) {
            LogFactory.getLog(SolrIndexer.class).error((Object)"Args must contain a non-null Resource to index");
            throw new IndexException("Args must contain a non-null Resource to index", wle);
        }
        if (!(args.getResource() instanceof MediaUnit)) {
            LogFactory.getLog(SolrIndexer.class).error((Object)"Resource to index as not a MediaUnit.");
            throw new IndexException("Resource to index as not a MediaUnit.", wle);
        }
        return (MediaUnit)args.getResource();
    }

    public WebServiceContext getWsContext() {
        return this.wsContext;
    }

    public void setWsContext(WebServiceContext wsContext) {
        this.wsContext = wsContext;
    }
}

