/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.searcher.impl;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.ow2.weblab.services.searcher.impl.SolrSearcherConfig;
import org.ow2.weblab.services.solr.SolrComponent;
import org.ow2.weblab.util.index.Field;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.factory.ResourceFactory;
import org.weblab_project.core.helper.BeanHelper;
import org.weblab_project.core.helper.PoKHelperExtended;
import org.weblab_project.core.helper.RDFHelperFactory;
import org.weblab_project.core.model.PieceOfKnowledge;
import org.weblab_project.core.model.query.Query;
import org.weblab_project.core.model.query.ResultSet;
import org.weblab_project.core.model.query.StringQuery;
import org.weblab_project.core.ontologies.WebLab;
import org.weblab_project.core.util.ResourceUtil;
import org.weblab_project.services.searcher.SearchException;
import org.weblab_project.services.searcher.Searcher;
import org.weblab_project.services.searcher.types.SearchArgs;
import org.weblab_project.services.searcher.types.SearchReturn;

@WebService(endpointInterface="org.weblab_project.services.searcher.Searcher")
public class SolrSearcher
implements Searcher {
    @Resource
    protected WebServiceContext wsContext;
    private static final Log logger = LogFactory.getLog(SolrSearcher.class);
    private static int resultsCpt = 0;
    private SolrSearcherConfig conf = (SolrSearcherConfig)BeanHelper.getInstance().getSpecificInstance("SearcherBean.xml", true).getBean("SearcherConfig", SolrSearcherConfig.class);
    private SolrComponent solrComponent = SolrComponent.getInstance();

    public SearchReturn search(SearchArgs arg0) throws SearchException {
        Query q = arg0.getQuery();
        int offset = arg0.getOffset() != null && arg0.getOffset() > 0 ? arg0.getOffset() : 0;
        int limit = arg0.getLimit() != null && arg0.getLimit() > 0 ? arg0.getLimit() : 10;
        SearchReturn re = new SearchReturn();
        re.setResultSet(this.search(q, offset, limit));
        return re;
    }

    public ResultSet search(Query q, int offset, int limit) throws SearchException {
        if (!(q instanceof StringQuery)) {
            throw new SearchException("This service " + this.getClass().getSimpleName() + " can only process " + StringQuery.class.getSimpleName() + " and not " + q.getClass().getSimpleName(), null);
        }
        StringQuery query = (StringQuery)q;
        try {
            logger.debug((Object)("query request : " + query.getRequest()));
            logger.debug((Object)("Query input : " + ResourceUtil.saveToXMLString((org.weblab_project.core.model.Resource)query)));
        }
        catch (WebLabCheckedException e) {
            logger.debug((Object)"Error when logging query input", (Throwable)e);
        }
        SearchReturn returnedResults = new SearchReturn();
        ResultSet results = (ResultSet)ResourceFactory.createResource((String)"eads.indexsearch.solr", (String)("result" + resultsCpt++), ResultSet.class);
        PieceOfKnowledge pok = (PieceOfKnowledge)ResourceFactory.createResource((String)"eads.indexsearch.solr", (String)("pok" + resultsCpt), PieceOfKnowledge.class);
        results.setPok(pok);
        PoKHelperExtended h = RDFHelperFactory.getPoKHelperExtended((PieceOfKnowledge)pok);
        h.setAutoCommitMode(false);
        returnedResults.setResultSet(results);
        for (String nsPrefix : this.conf.getNsPrefixProperties().keySet()) {
            h.setNSPrefix(nsPrefix, this.conf.getNsPrefixProperties().get(nsPrefix));
        }
        h.createResStat(results.getUri(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", WebLab.getUriFromClass(ResultSet.class));
        h.createResStat(results.getUri(), this.conf.getProperties().get("isResultOf"), q.getUri());
        for (Map.Entry<String, String> local : this.conf.getResultSetLabels().entrySet()) {
            h.createLitStat(results.getUri(), "http://www.w3.org/2000/01/rdf-schema#label", local.getValue(), local.getKey());
        }
        try {
            this.solrComponent.open(this.getWebAppPath());
            QueryResponse res = this.solrComponent.search(query.getRequest(), offset, limit);
            int resCpt = 0;
            SolrDocumentList resultDocs = res.getResults();
            Map highlightings = res.getHighlighting();
            if (resultDocs != null) {
                for (SolrDocument hit : resultDocs) {
                    String resourceUri = String.valueOf(hit.getFieldValue("id"));
                    String hitUri = "weblab://eads.indexsearch.solr/hit" + resCpt;
                    h.createResStat(hitUri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", this.conf.getHitClass());
                    h.createLitStat(hitUri, this.conf.getProperties().get("hasRank"), String.valueOf(offset + resCpt + 1));
                    h.createLitStat(hitUri, this.conf.getProperties().get("hasScore"), String.valueOf(hit.getFieldValue("score")));
                    if (highlightings != null && ((Map)highlightings.get(hit.getFieldValue("id"))).size() > 0) {
                        List hitHighlightingList = (List)((Map)highlightings.get(hit.getFieldValue("id"))).get("text");
                        StringBuffer snippet = new StringBuffer();
                        for (String hl : hitHighlightingList) {
                            snippet.append(hl);
                        }
                        h.createLitStat(hitUri, this.conf.getProperties().get("hasDescription"), snippet.toString());
                    }
                    h.createResStat(hitUri, this.conf.getProperties().get("isLinkedTo"), resourceUri);
                    h.createResStat(hitUri, this.conf.getProperties().get("inResultSet"), results.getUri());
                    if (this.conf.isHitsEnrichedWithMetas()) {
                        Map fields = hit.getFieldValuesMap();
                        for (Map.Entry<String, Field> confField : this.conf.getFieldsToRetrieve().entrySet()) {
                            Field field = confField.getValue();
                            if (!fields.containsKey(field.getName())) continue;
                            for (String property : field.getProperties()) {
                                Collection fieldValues = (Collection)fields.get(field.getName());
                                for (Object fieldValue : fieldValues) {
                                    if (fieldValue instanceof String) {
                                        if (field.getType().equals("URI")) {
                                            h.createResStat(resourceUri, property, ((String)fieldValue).trim());
                                            continue;
                                        }
                                        h.createLitStat(resourceUri, property, ((String)fieldValue).trim());
                                        continue;
                                    }
                                    if (!(fieldValue instanceof Date)) continue;
                                    h.createLitStat(resourceUri, property, DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format((Date)fieldValue));
                                }
                            }
                        }
                    }
                    ++resCpt;
                }
                h.createLitStat(results.getUri(), this.conf.getProperties().get("hasNumberOfResults"), String.valueOf(resultDocs.getNumFound()));
            } else {
                h.createLitStat(results.getUri(), this.conf.getProperties().get("hasNumberOfResults"), "0");
            }
            h.createLitStat(results.getUri(), this.conf.getProperties().get("offset"), String.valueOf(offset));
            if (this.conf.getFacetFields().size() > 0) {
                int facetCpt = 0;
                for (String facetFieldName : this.conf.getFacetFields()) {
                    List countList;
                    String facetUri = "weblab://eads.indexsearch.solrfacet" + resultsCpt + "_" + facetCpt++;
                    h.createResStat(facetUri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", this.conf.getFacetClass());
                    h.createLitStat(facetUri, "http://www.w3.org/2000/01/rdf-schema#label", facetFieldName);
                    h.createResStat(facetUri, this.conf.getIsLinkedToQueryClass(), q.getUri());
                    FacetField ff = res.getFacetField(facetFieldName);
                    if (ff == null || (countList = ff.getValues()) == null) continue;
                    int facetValueCpt = 0;
                    for (FacetField.Count count : countList) {
                        logger.debug((Object)("Create facet element: " + facetFieldName + "=" + count.getName() + "(" + count.getCount() + ")"));
                        String facetValueUri = "weblab://eads.indexsearch.solrfacetValue" + resultsCpt + "_" + facetCpt + "_" + facetValueCpt++;
                        h.createResStat(facetValueUri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", this.conf.getFacetValueClass());
                        h.createLitStat(facetValueUri, "http://www.w3.org/2000/01/rdf-schema#label", count.getName());
                        h.createLitStat(facetValueUri, this.conf.getFacetCountClass(), String.valueOf(count.getCount()));
                        h.createLitStat(facetValueUri, this.conf.getFacetFilterQueryClass(), count.getAsFilterQuery());
                        h.createResStat(facetValueUri, this.conf.getIsLinkedToFacetClass(), facetUri);
                    }
                }
            }
            h.commit();
        }
        catch (WebLabCheckedException e) {
            throw new SearchException("Cannot retrieve the results to query [" + query.getRequest() + "] - " + e.getMessage(), null);
        }
        return results;
    }

    private String getWebAppPath() throws WebLabCheckedException {
        String appPath = "./src/main/resources";
        if (this.wsContext != null) {
            ServletContext ctx = (ServletContext)this.wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
            appPath = ctx.getRealPath("WEB-INF/classes");
        } else {
            logger.warn((Object)"Webservice context not available returning current local path as default web app path");
        }
        File f = new File(appPath);
        if (!f.exists()) {
            throw new WebLabCheckedException("Webapp path [" + appPath + "] does not exists...");
        }
        return appPath;
    }

    public WebServiceContext getWsContext() {
        return this.wsContext;
    }

    public void setWsContext(WebServiceContext wsContext) {
        this.wsContext = wsContext;
    }
}

