/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.indexer.impl;

import java.io.File;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.services.Indexer;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.indexer.IndexArgs;
import org.ow2.weblab.core.services.indexer.IndexReturn;
import org.ow2.weblab.services.solr.SolrComponent;

/*
 * Exception performing whole class analysis ignored.
 */
@WebService(endpointInterface="org.ow2.weblab.core.services.Indexer")
public class SolrIndexer
implements Indexer {
    @javax.annotation.Resource
    protected WebServiceContext wsContext;
    private SolrComponent solr;

    private static MediaUnit checkArgs(IndexArgs args) throws InvalidParameterException {
        if (args == null) {
            LogFactory.getLog(SolrIndexer.class).error((Object)"IndexArgs was null.");
            throw new InvalidParameterException("IndexArgs was null.", "IndexArgs was null.");
        }
        if (args.getResource() == null) {
            LogFactory.getLog(SolrIndexer.class).error((Object)"Args must contain a non-null Resource to index");
            throw new InvalidParameterException("Args must contain a non-null Resource to index", "Args must contain a non-null Resource to index");
        }
        if (!(args.getResource() instanceof MediaUnit)) {
            LogFactory.getLog(SolrIndexer.class).error((Object)"Resource to index as not a MediaUnit.");
            throw new InvalidParameterException("Resource to index as not a MediaUnit.", "Resource to index as not a MediaUnit.");
        }
        return (MediaUnit)args.getResource();
    }

    @PostConstruct
    public void init() {
        this.solr = SolrComponent.getInstance();
    }

    public IndexReturn index(IndexArgs args) throws UnexpectedException, InvalidParameterException {
        MediaUnit unit = SolrIndexer.checkArgs((IndexArgs)args);
        try {
            if (this.solr == null) {
                this.solr = SolrComponent.getInstance();
            }
            this.solr.open(this.getWebAppPath());
            this.solr.addDocument((Resource)unit);
        }
        catch (WebLabCheckedException e) {
            throw new UnexpectedException("Cannot open Solr index.", e.getMessage());
        }
        return new IndexReturn();
    }

    @PreDestroy
    public void destroy() {
        if (this.solr != null) {
            this.solr.close();
        }
    }

    protected String getWebAppPath() throws WebLabCheckedException {
        String appPath = null;
        if (this.wsContext != null) {
            ServletContext ctx = (ServletContext)this.wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
            appPath = ctx.getRealPath("WEB-INF/classes");
        } else {
            LogFactory.getLog(SolrIndexer.class).warn((Object)"Webservice context not available returning current local path as default web app path");
        }
        if (appPath == null) {
            throw new WebLabCheckedException("Webapp path [" + appPath + "] is null...");
        }
        if (!new File(appPath).exists()) {
            throw new WebLabCheckedException("Webapp path [" + appPath + "] does not exists...");
        }
        return appPath;
    }

    public WebServiceContext getWsContext() {
        return this.wsContext;
    }

    public void setWsContext(WebServiceContext wsContext) {
        this.wsContext = wsContext;
    }
}

