/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.services.query;

import javax.jws.WebService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.weblab_project.core.factory.ResourceFactory;
import org.weblab_project.core.model.query.StringQuery;
import org.weblab_project.services.stringquerycreator.CreateQueryException;
import org.weblab_project.services.stringquerycreator.StringQueryCreator;
import org.weblab_project.services.stringquerycreator.types.CreateQueryArgs;
import org.weblab_project.services.stringquerycreator.types.CreateQueryReturn;

/**
 * @author BA
 * @date 2009-07-03
 */
@WebService(endpointInterface = "org.weblab_project.services.stringquerycreator.StringQueryCreator")
public class StringQueryCreatorService implements StringQueryCreator {

	/**
	 * The <code>Log</code> to be used.
	 */
	private static Log LOG = LogFactory.getLog(StringQueryCreatorService.class);

	public StringQueryCreatorService() {
		super();
	}

	@Override
    public CreateQueryReturn createQuery(CreateQueryArgs args) throws CreateQueryException
    {
		String dcSource = args.getSource();

		LOG.debug("start createQuery, dcSource=" + dcSource);
		
		dcSource = dcSource.replaceAll("\\\\", "\\\\\\\\");
		
		CreateQueryReturn ret = new CreateQueryReturn();
		
		StringQuery query = ResourceFactory.createResource("StringQueryCreator", "query-" + System.nanoTime(), StringQuery.class);
		
		query.setRequest("source:\"" + dcSource + "\"");

		LOG.debug("created query=" + query);

		ret.setQuery(query);
		
	    return ret;
    }
}
