/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.Chunks;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.hsmf.parsers.POIFSChunkParser;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class CustomOutlookExtractor {
    private final Chunks CHUNKS;
    private final POIFSChunkParser parser;

    public CustomOutlookExtractor(POIFSFileSystem filesystem) throws TikaException {
        try {
            this.parser = new POIFSChunkParser(filesystem);
            this.CHUNKS = this.parser.identifyChunks();
        }
        catch (IOException e) {
            throw new TikaException("Failed to parse Outlook chunks", (Throwable)e);
        }
    }

    public void parse(XHTMLContentHandler xhtml, Metadata metadata) throws TikaException, SAXException {
        String subject = this.getChunk(this.CHUNKS.subjectChunk);
        String from = this.getChunk(this.CHUNKS.displayFromChunk);
        metadata.set("Author", from);
        metadata.set("title", subject);
        metadata.set("subject", this.getChunk(this.CHUNKS.conversationTopic));
        xhtml.element("h1", subject);
        xhtml.startElement("dl");
        this.header(xhtml, "From", from);
        this.header(xhtml, "To", this.getChunk(this.CHUNKS.displayToChunk));
        this.header(xhtml, "Cc", this.getChunk(this.CHUNKS.displayCCChunk));
        this.header(xhtml, "Bcc", this.getChunk(this.CHUNKS.displayBCCChunk));
        xhtml.endElement("dl");
        xhtml.element("div", this.getChunk(this.CHUNKS.textBodyChunk));
        Map attachments = this.parser.getAttachmentList();
        AutoDetectParser parser = new AutoDetectParser();
        Iterator iterator = attachments.keySet().iterator();
        while (iterator.hasNext()) {
            Metadata attachmentMetadata = new Metadata();
            String fileName = (String)iterator.next();
            ByteArrayInputStream fileContent = (ByteArrayInputStream)attachments.get(fileName);
            BodyContentHandler handlerAttachments = new BodyContentHandler();
            try {
                parser.parse((InputStream)fileContent, (ContentHandler)handlerAttachments, attachmentMetadata);
            }
            catch (IOException e) {
                throw new TikaException("Failed to parse Outlook attachment", (Throwable)e);
            }
            xhtml.element("div", handlerAttachments.toString());
        }
    }

    private void header(XHTMLContentHandler xhtml, String key, String value) throws SAXException {
        if (value.length() > 0) {
            xhtml.element("dt", key);
            xhtml.element("dd", value);
        }
    }

    private String getChunk(StringChunk chunk) {
        try {
            return this.parser.getDocumentNode((Chunk)chunk).toString();
        }
        catch (ChunkNotFoundException e) {
            return "";
        }
    }
}

