/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EmlParser
implements Parser {
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        block6: {
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            Properties props = System.getProperties();
            Session mailSession = Session.getDefaultInstance((Properties)props, null);
            try {
                MimeMessage message = new MimeMessage(mailSession, stream);
                String subject = message.getSubject();
                String from = this.convertAddressesToString(message.getFrom());
                String to = this.convertAddressesToString(message.getRecipients(Message.RecipientType.TO));
                String cc = this.convertAddressesToString(message.getRecipients(Message.RecipientType.CC));
                String bcc = this.convertAddressesToString(message.getRecipients(Message.RecipientType.BCC));
                metadata.set("Author", from);
                metadata.set("title", subject);
                metadata.set("subject", subject);
                xhtml.element("h1", subject);
                xhtml.startElement("dl");
                this.header(xhtml, "From", from);
                this.header(xhtml, "To", to.toString());
                this.header(xhtml, "Cc", cc.toString());
                this.header(xhtml, "Bcc", bcc.toString());
                xhtml.endElement("dl");
                if (message.getContent() instanceof MimeMultipart) {
                    MimeMultipart multipart = (MimeMultipart)message.getContent();
                    this.extractMultipart(xhtml, multipart, context);
                    break block6;
                }
                AutoDetectParser parser = new AutoDetectParser();
                BodyContentHandler handlerContent = new BodyContentHandler();
                try {
                    parser.parse((InputStream)new ByteArrayInputStream(message.getContent().toString().getBytes()), (ContentHandler)handlerContent, metadata, context);
                }
                catch (IOException e) {
                    throw new TikaException("Failed to parse Outlook message body", (Throwable)e);
                }
                xhtml.element("div", handlerContent.toString());
            }
            catch (MessagingException e) {
                throw new TikaException("Error while processing message", (Throwable)e);
            }
            catch (IOException e) {
                throw new TikaException("Error while processing message", (Throwable)e);
            }
        }
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    private void header(XHTMLContentHandler xhtml, String key, String value) throws SAXException {
        if (value.length() > 0) {
            xhtml.element("dt", key);
            xhtml.element("dd", value);
        }
    }

    private String convertAddressesToString(Address[] addresses) {
        StringBuilder result = new StringBuilder();
        if (addresses != null) {
            for (int i = 0; i < addresses.length; ++i) {
                String addressToAdd = addresses[i].toString().replaceAll("<", "").replaceAll(">", "");
                result.append(addressToAdd).append("; ");
            }
            int resultLength = result.length();
            if (resultLength > 1) {
                result.delete(resultLength - 2, resultLength);
            }
        }
        return result.toString();
    }

    private void extractMultipart(XHTMLContentHandler xhtml, MimeMultipart multipart, ParseContext context) throws MessagingException, IOException, SAXException, TikaException {
        for (int i = 0; i < multipart.getCount(); ++i) {
            MimeBodyPart bodyPart = (MimeBodyPart)multipart.getBodyPart(i);
            if (bodyPart.getDisposition() == null) {
                MimeMultipart subMultipart = (MimeMultipart)bodyPart.getContent();
                for (int j = 0; j < subMultipart.getCount(); ++j) {
                    MimeBodyPart subBodyPart = (MimeBodyPart)subMultipart.getBodyPart(j);
                    if (!subBodyPart.getContentType().startsWith("text/plain")) continue;
                    xhtml.element("div", subBodyPart.getContent().toString());
                }
                continue;
            }
            if (!bodyPart.getDisposition().equals("attachment")) continue;
            InputStream fileContent = bodyPart.getInputStream();
            AutoDetectParser parser = new AutoDetectParser();
            Metadata attachmentMetadata = new Metadata();
            BodyContentHandler handlerAttachments = new BodyContentHandler();
            parser.parse(fileContent, (ContentHandler)handlerAttachments, attachmentMetadata, context);
            xhtml.element("div", handlerAttachments.toString());
        }
    }
}

