/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.normaliser.tika;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.weblab_project.core.factory.MediaUnitFactory;
import org.weblab_project.core.model.ComposedUnit;
import org.weblab_project.core.model.text.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MediaUnitContentHandler
extends ContentHandlerDecorator {
    private ComposedUnit cu;
    private Text textInProcess;
    private boolean isInBody;
    private boolean tableElementDetected;
    private static List<String> NEW_LINE_ELEMENTS;
    private static List<String> ITEM_LIST_ELEMENTS;

    public MediaUnitContentHandler(ContentHandler handler, ComposedUnit cu) {
        super(handler);
        this.cu = cu;
        this.isInBody = false;
        this.tableElementDetected = false;
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        super.startElement(uri, localName, name, atts);
        if (name.equals("body")) {
            this.isInBody = true;
        }
        if (name.equals("div")) {
            this.textInProcess = (Text)MediaUnitFactory.createAndLinkMediaUnit((ComposedUnit)this.cu, Text.class);
            this.textInProcess.setContent("");
        }
        if (this.textInProcess != null) {
            if (NEW_LINE_ELEMENTS.contains(name)) {
                this.textInProcess.setContent(this.textInProcess.getContent() + System.getProperty("line.separator"));
            }
            if (ITEM_LIST_ELEMENTS.contains(name)) {
                this.textInProcess.setContent(this.textInProcess.getContent() + "\t- ");
            }
            if (name.equals("table")) {
                this.tableElementDetected = true;
            }
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (this.textInProcess != null) {
            if (name.equals("div")) {
                this.textInProcess = null;
            }
            if (name.equals("tr")) {
                this.textInProcess.setContent(this.textInProcess.getContent() + "\n");
            }
            if (name.equals("td")) {
                this.textInProcess.setContent(this.textInProcess.getContent() + "\t");
            }
        }
        if (name.equals("table")) {
            this.tableElementDetected = false;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (this.isInBody) {
            if (this.textInProcess == null) {
                this.textInProcess = (Text)MediaUnitFactory.createAndLinkMediaUnit((ComposedUnit)this.cu, Text.class);
                this.textInProcess.setContent("");
            }
            int end = start + length;
            StringBuilder sb = new StringBuilder();
            for (int i = start; i < end; ++i) {
                sb.append(ch[i]);
            }
            if (this.tableElementDetected) {
                this.textInProcess.setContent(this.textInProcess.getContent() + sb.toString().trim());
            } else {
                this.textInProcess.setContent(this.textInProcess.getContent() + sb.toString());
            }
        }
    }

    static {
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.add("p");
        tempList.add("table");
        tempList.add("dd");
        tempList.add("dt");
        tempList.add("li");
        NEW_LINE_ELEMENTS = Collections.unmodifiableList(tempList);
        ArrayList<String> tempList2 = new ArrayList<String>();
        tempList2.add("li");
        ITEM_LIST_ELEMENTS = Collections.unmodifiableList(tempList2);
    }
}

