/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PagedText;
import org.apache.tika.metadata.Property;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.pdf.CustomPDF2XHTML;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CustomPDFParser
implements Parser {
    private static final long serialVersionUID = -752276948656079347L;
    public static final String PASSWORD = "org.apache.tika.parser.pdf.password";
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"pdf"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        PDDocument pdfDocument = PDDocument.load((InputStream)stream, (boolean)true);
        try {
            if (pdfDocument.isEncrypted()) {
                try {
                    String password = metadata.get(PASSWORD);
                    if (password == null) {
                        password = "";
                    }
                    pdfDocument.decrypt(password);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            metadata.set("Content-Type", "application/pdf");
            this.extractMetadata(pdfDocument, metadata);
            CustomPDF2XHTML.process(pdfDocument, handler, metadata);
        }
        finally {
            pdfDocument.close();
        }
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    private void extractMetadata(PDDocument document, Metadata metadata) throws TikaException {
        PDDocumentInformation info = document.getDocumentInformation();
        metadata.set(PagedText.N_PAGES, document.getNumberOfPages());
        this.addMetadata(metadata, "title", info.getTitle());
        this.addMetadata(metadata, "Author", info.getAuthor());
        this.addMetadata(metadata, "creator", info.getCreator());
        this.addMetadata(metadata, "Keywords", info.getKeywords());
        this.addMetadata(metadata, "producer", info.getProducer());
        this.addMetadata(metadata, "subject", info.getSubject());
        this.addMetadata(metadata, "trapped", info.getTrapped());
        try {
            this.addMetadata(metadata, "created", info.getCreationDate());
            this.addMetadata(metadata, Metadata.CREATION_DATE, info.getCreationDate());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            Calendar modified = info.getModificationDate();
            this.addMetadata(metadata, Metadata.LAST_MODIFIED, modified);
        }
        catch (IOException e) {
            // empty catch block
        }
        List<String> handledMetadata = Arrays.asList("Author", "Creator", "CreationDate", "ModDate", "Keywords", "Producer", "Subject", "Title", "Trapped");
        for (COSName key : info.getDictionary().keySet()) {
            String name = key.getName();
            if (handledMetadata.contains(name)) continue;
            this.addMetadata(metadata, name, info.getDictionary().getDictionaryObject(key));
        }
    }

    private void addMetadata(Metadata metadata, String name, String value) {
        if (value != null) {
            metadata.add(name, value);
        }
    }

    private void addMetadata(Metadata metadata, String name, Calendar value) {
        if (value != null) {
            metadata.set(name, value.getTime().toString());
        }
    }

    private void addMetadata(Metadata metadata, Property property, Calendar value) {
        if (value != null) {
            metadata.set(property, value.getTime());
        }
    }

    private void addMetadata(Metadata metadata, String name, COSBase value) {
        if (value instanceof COSArray) {
            for (COSBase v : ((COSArray)value).toList()) {
                this.addMetadata(metadata, name, v);
            }
        } else if (value instanceof COSString) {
            this.addMetadata(metadata, name, ((COSString)value).getString());
        } else {
            this.addMetadata(metadata, name, value.toString());
        }
    }
}

