/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.normaliser.tika;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.language.ProfilingWriter;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.ow2.weblab.content.ContentManager;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.factory.AnnotationFactory;
import org.ow2.weblab.core.extended.factory.MediaUnitFactory;
import org.ow2.weblab.core.helper.PoKHelper;
import org.ow2.weblab.core.helper.RDFHelperFactory;
import org.ow2.weblab.core.model.Annotation;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.Image;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MediaUnitContentHandler
extends ContentHandlerDecorator {
    private static final Log logger = LogFactory.getLog(MediaUnitContentHandler.class);
    private static final int MIN_IMAGE_WIDTH = 100;
    private static final int MIN_IMAGE_HEIGHT = 100;
    private Annotation docLangAnnot;
    private Document document;
    private ProfilingWriter pWriter;
    private ProfilingWriter pTableWriter;
    private Text textInProcess;
    private Text tableInProcess;
    private String muHtmlElement;
    private static List<String> NEW_LINE_ELEMENTS;
    private static List<String> TAB_LIST_ELEMENTS;
    private static List<String> TITLE_LIST_ELEMENTS;
    private static List<String> BLOC_LIST_ELEMENTS;

    public MediaUnitContentHandler(ContentHandler handler, Document document) {
        super(handler);
        this.document = document;
        this.muHtmlElement = "";
        this.textInProcess = null;
        this.tableInProcess = null;
    }

    private void openTextMediaUnit() {
        this.textInProcess = (Text)MediaUnitFactory.createAndLinkMediaUnit((Resource)this.document, Text.class);
        this.textInProcess.setContent("");
        this.pWriter = new ProfilingWriter();
    }

    private void OpenTableMediaUnit() {
        this.tableInProcess = (Text)MediaUnitFactory.createAndLinkMediaUnit((Resource)this.document, Text.class);
        this.tableInProcess.setContent("");
        this.pTableWriter = new ProfilingWriter();
    }

    private void closeTextMediaUnit() {
        String content = this.textInProcess.getContent().replaceAll("\t", "").replaceAll("\n", "").replaceAll("\r", "").trim();
        if (content.isEmpty() || content.length() < 4) {
            this.document.getMediaUnit().remove(this.textInProcess);
        } else if (this.textInProcess.getContent().length() > 200) {
            this.annotate((Resource)this.textInProcess, this.pWriter.getLanguage().getLanguage());
        }
        this.textInProcess = null;
        this.pWriter = null;
    }

    private void CloseTableMediaUnit() {
        String content = this.tableInProcess.getContent().replaceAll("\t", "").replaceAll("\n", "").replaceAll("\r", "").trim();
        if (content.isEmpty()) {
            this.document.getMediaUnit().remove(this.tableInProcess);
        } else if (this.tableInProcess.getContent().length() > 200) {
            this.annotate((Resource)this.tableInProcess, this.pTableWriter.getLanguage().getLanguage());
        }
        this.tableInProcess = null;
        this.pTableWriter = null;
    }

    private void AddImageMediaUnit(Attributes atts) {
        block15: {
            String src = atts.getValue("src");
            String contentURI = "";
            BufferedImage image = null;
            if (src.endsWith(".jpg") || src.endsWith(".png") || src.endsWith(".bmp")) {
                try {
                    if (src.startsWith("http://")) {
                        URL url = new URL(src);
                        image = ImageIO.read(url);
                        contentURI = src;
                    }
                    if (image == null || image.getWidth() <= 100 || image.getHeight() <= 100) break block15;
                    Image ImageMU = (Image)MediaUnitFactory.createAndLinkMediaUnit((Resource)this.document, Image.class);
                    ImageMU.setUri(ImageMU.getUri());
                    String baseUri = "http://weblab.eads.com/service/format/tika/";
                    if (contentURI.isEmpty()) {
                        File file = new File(src);
                        contentURI = "weblab://images/content/" + file.getName();
                        ContentManager contentManager = ContentManager.getInstance();
                        if (contentManager == null) {
                            throw new WebLabUncheckedException("Unable to load required properties file for content management.");
                        }
                        try {
                            contentManager.saveNativeContent((InputStream)new FileInputStream(file), (Resource)ImageMU);
                        }
                        catch (WebLabCheckedException e1) {
                            logger.warn((Object)"Unable to copy image.", (Throwable)e1);
                        }
                    }
                    for (int i = 0; i < atts.getLength(); ++i) {
                        if (!"alt".equals(atts.getLocalName(i)) && !"title".equals(atts.getLocalName(i))) continue;
                        Annotation muImageAnnot = AnnotationFactory.createAndLinkAnnotation((Resource)ImageMU);
                        PoKHelper pokH = RDFHelperFactory.getPoKHelper((PieceOfKnowledge)muImageAnnot);
                        pokH.setAutoCommitMode(false);
                        if ("alt".equals(atts.getLocalName(i))) {
                            pokH.createLitStat(ImageMU.getUri(), baseUri + "alt", atts.getValue(i).replace("<br/>", ""));
                        } else {
                            pokH.createLitStat(ImageMU.getUri(), "http://purl.org/dc/elements/1.1/title", atts.getValue(i).replace("<br/>", ""));
                        }
                        pokH.commit();
                        break;
                    }
                    try {
                        Annotation muImageAnnot = AnnotationFactory.createAndLinkAnnotation((Resource)ImageMU);
                        PoKHelper pokH = RDFHelperFactory.getPoKHelper((PieceOfKnowledge)muImageAnnot);
                        pokH.setAutoCommitMode(false);
                        pokH.createLitStat(ImageMU.getUri(), new URL(baseUri + "width").toURI().toString(), String.valueOf(image.getWidth()));
                        pokH.createLitStat(ImageMU.getUri(), new URL(baseUri + "height").toURI().toString(), String.valueOf(image.getHeight()));
                        pokH.commit();
                    }
                    catch (MalformedURLException e1) {
                        logger.warn((Object)("Malformed URL : " + baseUri + "width" + ")"));
                    }
                    catch (URISyntaxException e1) {
                        logger.warn((Object)("Unable to transform the property 'width' into a predicate (" + baseUri + "width" + ")"));
                    }
                }
                catch (MalformedURLException e) {
                    logger.info((Object)("Unable to read image. " + src + " can not be transformed to URI."));
                }
                catch (IOException e) {
                    logger.info((Object)("Unable to convert to image : " + src));
                }
            }
        }
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        super.startElement(uri, localName, name, atts);
        if (name.equals("body")) {
            this.muHtmlElement = name;
        }
        if (this.tableInProcess == null) {
            if (TITLE_LIST_ELEMENTS.contains(name)) {
                if (this.textInProcess == null) {
                    this.openTextMediaUnit();
                    this.muHtmlElement = name;
                } else if (this.muHtmlElement.equals(name) || this.muHtmlElement.equals("body")) {
                    this.closeTextMediaUnit();
                    this.muHtmlElement = name;
                    this.openTextMediaUnit();
                } else {
                    this.textInProcess.setContent(this.textInProcess.getContent() + System.getProperty("line.separator"));
                }
            }
            if (BLOC_LIST_ELEMENTS.contains(name)) {
                if (this.textInProcess == null) {
                    this.openTextMediaUnit();
                    this.muHtmlElement = name;
                } else if (TITLE_LIST_ELEMENTS.contains(this.muHtmlElement) || BLOC_LIST_ELEMENTS.contains(this.muHtmlElement)) {
                    this.textInProcess.setContent(this.textInProcess.getContent() + System.getProperty("line.separator"));
                } else {
                    this.closeTextMediaUnit();
                    this.muHtmlElement = name;
                    this.openTextMediaUnit();
                }
            }
            if (name.equals("table")) {
                this.OpenTableMediaUnit();
                if (this.textInProcess != null) {
                    this.closeTextMediaUnit();
                }
            }
        }
        if (name.equals("img")) {
            this.AddImageMediaUnit(atts);
            if (this.tableInProcess == null && this.textInProcess != null) {
                if (BLOC_LIST_ELEMENTS.contains(this.muHtmlElement)) {
                    this.textInProcess.setContent(this.textInProcess.getContent() + System.getProperty("line.separator"));
                } else {
                    this.closeTextMediaUnit();
                }
            }
        }
        if (this.textInProcess != null) {
            if (NEW_LINE_ELEMENTS.contains(name)) {
                this.textInProcess.setContent(this.textInProcess.getContent() + System.getProperty("line.separator"));
            }
            if (TAB_LIST_ELEMENTS.contains(name)) {
                this.textInProcess.setContent(this.textInProcess.getContent() + "\t");
            }
            if (name.equals("a") || name.equals("span")) {
                this.textInProcess.setContent(this.textInProcess.getContent() + " ");
            }
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (this.tableInProcess != null) {
            if (name.equals("tr")) {
                this.tableInProcess.setContent(this.tableInProcess.getContent() + "\n");
            } else if (name.equals("td")) {
                this.tableInProcess.setContent(this.tableInProcess.getContent() + "\t");
            } else if (name.equals("table")) {
                this.CloseTableMediaUnit();
            }
        } else if (this.textInProcess != null) {
            if (name.equals("br")) {
                this.tableInProcess.setContent(this.tableInProcess.getContent() + "\n");
            }
            if (name.equals(this.muHtmlElement) && !TITLE_LIST_ELEMENTS.contains(this.muHtmlElement) || name.equals("body")) {
                this.closeTextMediaUnit();
                this.muHtmlElement = "body";
            } else if (BLOC_LIST_ELEMENTS.contains(name) || NEW_LINE_ELEMENTS.contains(name) || TITLE_LIST_ELEMENTS.contains(name)) {
                this.textInProcess.setContent(this.textInProcess.getContent() + System.getProperty("line.separator"));
            } else {
                this.textInProcess.setContent(this.textInProcess.getContent() + " ");
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (this.muHtmlElement != "") {
            int end = start + length;
            StringBuilder sb = new StringBuilder();
            for (int i = start; i < end; ++i) {
                sb.append(ch[i]);
            }
            String content = sb.toString().replaceAll("\t", "").replaceAll("\n", "").replaceAll("\r", "").trim();
            if (content.length() != 0) {
                content = sb.toString().replaceAll("\t", " ").replaceAll("\n", " ").replaceAll("\r", " ").replaceAll("  ", " ");
                if (this.textInProcess == null && this.tableInProcess == null) {
                    this.openTextMediaUnit();
                }
                if (this.tableInProcess != null) {
                    this.tableInProcess.setContent(this.tableInProcess.getContent() + content);
                    try {
                        this.pTableWriter.append((CharSequence)sb.toString());
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage());
                    }
                } else {
                    this.textInProcess.setContent(this.textInProcess.getContent() + content);
                    try {
                        this.pWriter.append((CharSequence)sb.toString());
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage());
                    }
                }
            }
        }
    }

    private void annotate(Resource mu, String language) {
        if (this.docLangAnnot == null) {
            this.docLangAnnot = AnnotationFactory.createAndLinkAnnotation((Resource)this.document);
        }
        PoKHelper pokH = RDFHelperFactory.getPoKHelper((PieceOfKnowledge)this.docLangAnnot);
        pokH.setAutoCommitMode(false);
        pokH.createLitStat(this.document.getUri(), "http://purl.org/dc/elements/1.1/language", language);
        pokH.commit();
        Annotation muLangAnnot = AnnotationFactory.createAndLinkAnnotation((Resource)mu);
        pokH = RDFHelperFactory.getPoKHelper((PieceOfKnowledge)muLangAnnot);
        pokH.setAutoCommitMode(false);
        pokH.createLitStat(mu.getUri(), "http://purl.org/dc/elements/1.1/language", language);
        pokH.commit();
    }

    static {
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.add("ol");
        tempList.add("dt");
        tempList.add("dl");
        tempList.add("li");
        NEW_LINE_ELEMENTS = Collections.unmodifiableList(tempList);
        ArrayList<String> tempList2 = new ArrayList<String>();
        tempList2.add("li");
        tempList2.add("dd");
        TAB_LIST_ELEMENTS = Collections.unmodifiableList(tempList2);
        ArrayList<String> tempList3 = new ArrayList<String>();
        tempList3.add("h1");
        tempList3.add("h2");
        tempList3.add("h3");
        tempList3.add("h4");
        tempList3.add("h5");
        tempList3.add("h6");
        TITLE_LIST_ELEMENTS = Collections.unmodifiableList(tempList3);
        ArrayList<String> tempList4 = new ArrayList<String>();
        tempList4.add("div");
        tempList4.add("p");
        BLOC_LIST_ELEMENTS = Collections.unmodifiableList(tempList4);
    }
}

