/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.services.normaliser.xml;

import java.util.List;

public class NormaliserConfig {

	/**
	 * default name for indexer configuration bean
	 */
	public static final String DEFAULT_BEAN_NAME = "NormaliserConfig";
	/**
	 * default name for configuration file
	 */
	public static final String DEFAULT_CONF_FILE = "NormaliserConfigBean.xml";
	
	/**
	 * indicates if normaliser must override properties already presents in Resource 
	 */
	boolean overrideMode;
	
	List<XmlProperty> propertyList;

	public NormaliserConfig() {
		super();
	}

	public NormaliserConfig(List<XmlProperty> propertyList) {
		super();
		this.propertyList = propertyList;
	}

	/**
	 * @return the overrideMode
	 */
	public boolean isInOverrrideMode() {
		return this.overrideMode;
	}

	/**
	 * @param overrideMode the overrideMode to set
	 */
	public void setOverrideMode(boolean overwriteResourceProps) {
		this.overrideMode = overwriteResourceProps;
	}

	/**
	 * @return the propertyList
	 */
	public List<XmlProperty> getPropertyList() {
		return this.propertyList;
	}

	/**
	 * @param propertyList the propertyList to set
	 */
	public void setPropertyList(List<XmlProperty> propertyList) {
		this.propertyList = propertyList;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (this.overrideMode ? 1231 : 1237);
		result = prime * result + ((this.propertyList == null) ? 0 : this.propertyList.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		NormaliserConfig other = (NormaliserConfig) obj;
		if (this.overrideMode != other.overrideMode)
			return false;
		if (this.propertyList == null) {
			if (other.propertyList != null)
				return false;
		}
		else if (!this.propertyList.equals(other.propertyList))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "NormaliserConfig [overrideMode=" + this.overrideMode + ", propertyList=" + this.propertyList
				+ "]";
	}
	
}
