/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.services.normaliser.xml;

import java.util.List;

public class XmlProperty {

	public enum NormalisedPropertyType {
		LITERAL, RESOURCE
	}
	
	protected String xpathExpression;
	protected boolean appendValuesToTextUnit;
	protected NormalisedPropertyType normalisedPropertyType;
	protected List<String> normalisedPropertyURI;
	
	public XmlProperty() {
		super();
	}

	public XmlProperty(String xpathExpression, boolean appendValuesToTextUnit,
			NormalisedPropertyType normalisedPropertyType, List<String> normalisedPropertyURI) {
		super();
		this.xpathExpression = xpathExpression;
		this.appendValuesToTextUnit = appendValuesToTextUnit;
		this.normalisedPropertyType = normalisedPropertyType;
		this.normalisedPropertyURI = normalisedPropertyURI;
	}

	/**
	 * @return the xpathExpression
	 */
	public String getXpathExpression() {
		return this.xpathExpression;
	}

	/**
	 * @param xpathExpression the xpathExpression to set
	 */
	public void setXpathExpression(String xpathExpression) {
		this.xpathExpression = xpathExpression;
	}

	/**
	 * @return the appendValuesToTextUnit
	 */
	public boolean isAppendValuesToTextUnit() {
		return this.appendValuesToTextUnit;
	}

	/**
	 * @param appendValuesToTextUnit the appendValuesToTextUnit to set
	 */
	public void setAppendValuesToTextUnit(boolean appendValuesToTextUnit) {
		this.appendValuesToTextUnit = appendValuesToTextUnit;
	}

	/**
	 * @return the normalisedPropertyType
	 */
	public NormalisedPropertyType getNormalisedPropertyType() {
		return this.normalisedPropertyType;
	}

	/**
	 * @param normalisedPropertyType the normalisedPropertyType to set
	 */
	public void setNormalisedPropertyType(NormalisedPropertyType normalisedPropertyType) {
		this.normalisedPropertyType = normalisedPropertyType;
	}

	/**
	 * @return the normalisedPropertyURI
	 */
	public List<String> getNormalisedPropertyURI() {
		return this.normalisedPropertyURI;
	}

	/**
	 * @param normalisedPropertyURI the normalisedPropertyURI to set
	 */
	public void setNormalisedPropertyURI(List<String> normalisedPropertyURI) {
		this.normalisedPropertyURI = normalisedPropertyURI;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (this.appendValuesToTextUnit ? 1231 : 1237);
		result = prime * result + ((this.normalisedPropertyType == null) ? 0 : this.normalisedPropertyType.hashCode());
		result = prime * result + ((this.normalisedPropertyURI == null) ? 0 : this.normalisedPropertyURI.hashCode());
		result = prime * result + ((this.xpathExpression == null) ? 0 : this.xpathExpression.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		XmlProperty other = (XmlProperty) obj;
		if (this.appendValuesToTextUnit != other.appendValuesToTextUnit)
			return false;
		if (this.normalisedPropertyType == null) {
			if (other.normalisedPropertyType != null)
				return false;
		}
		else if (!this.normalisedPropertyType.equals(other.normalisedPropertyType))
			return false;
		if (this.normalisedPropertyURI == null) {
			if (other.normalisedPropertyURI != null)
				return false;
		}
		else if (!this.normalisedPropertyURI.equals(other.normalisedPropertyURI))
			return false;
		if (this.xpathExpression == null) {
			if (other.xpathExpression != null)
				return false;
		}
		else if (!this.xpathExpression.equals(other.xpathExpression))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "XmlProperty [appendValuesToTextUnit=" + this.appendValuesToTextUnit + ", normalisedPropertyType="
				+ this.normalisedPropertyType + ", normalisedPropertyURI=" + this.normalisedPropertyURI + ", xpathExpression="
				+ this.xpathExpression + "]";
	}
	
	
	
}
