/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.services.normaliser.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jws.WebService;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.content.binary.BinaryFolderContentManager;
import org.ow2.weblab.services.normaliser.xml.NormaliserConfig;
import org.ow2.weblab.services.normaliser.xml.XmlProperty;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.weblab_project.core.exception.WebLabCheckedException;
import org.weblab_project.core.factory.AnnotationFactory;
import org.weblab_project.core.factory.MediaUnitFactory;
import org.weblab_project.core.helper.BeanHelper;
import org.weblab_project.core.helper.PoKHelper;
import org.weblab_project.core.helper.RDFHelperFactory;
import org.weblab_project.core.helper.ResourceHelper;
import org.weblab_project.core.model.Annotation;
import org.weblab_project.core.model.ComposedUnit;
import org.weblab_project.core.model.PieceOfKnowledge;
import org.weblab_project.core.model.Resource;
import org.weblab_project.core.model.text.Text;
import org.weblab_project.services.analyser.Analyser;
import org.weblab_project.services.analyser.ProcessException;
import org.weblab_project.services.analyser.types.ProcessArgs;
import org.weblab_project.services.analyser.types.ProcessReturn;
import org.weblab_project.services.exception.WebLabException;
import org.xml.sax.SAXException;

@WebService(endpointInterface="org.weblab_project.services.analyser.Analyser")
public class XmlNormaliser
implements Analyser {
    private static final Log logger = LogFactory.getLog(XmlNormaliser.class);
    private BinaryFolderContentManager contentManager = BinaryFolderContentManager.getInstance();
    private static List<String> XML_TYPES;
    private NormaliserConfig conf = (NormaliserConfig)BeanHelper.getInstance().getSpecificInstance("NormaliserConfigBean.xml", true).getBean("NormaliserConfig", NormaliserConfig.class);

    public ProcessReturn process(ProcessArgs args) throws ProcessException {
        Document doc;
        DocumentBuilder builder;
        File file;
        ProcessReturn pr = new ProcessReturn();
        ComposedUnit cu = XmlNormaliser.checkArgs(args);
        ResourceHelper resourceHelper = RDFHelperFactory.getResourceHelper((Resource)cu);
        List formatList = resourceHelper.getLitsOnPredSubj(cu.getUri(), "http://purl.org/dc/elements/1.1/format");
        if (formatList != null && formatList.size() > 0) {
            boolean isXml = false;
            for (String type : XML_TYPES) {
                if (!((String)formatList.get(0)).toLowerCase().contains(type)) continue;
                isXml = true;
            }
            if (!isXml) {
                logger.warn((Object)"Non XML resources could not be processed by XML normaliser");
                pr.setResource((Resource)cu);
                return pr;
            }
        } else {
            logger.warn((Object)("http://purl.org/dc/elements/1.1/format property not found, " + cu.getUri() + " will not be processed by XML normaliser."));
            pr.setResource((Resource)cu);
            return pr;
        }
        logger.info((Object)("Process the document " + cu.getUri() + "."));
        try {
            file = this.contentManager.getNativeFileFromResource((Resource)cu);
        }
        catch (WebLabCheckedException wlce) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E3");
            wle.setErrorMessage("Content not available");
            throw new ProcessException("Unable to retrieve content.", wle, (Throwable)wlce);
        }
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        try {
            builder = domFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E5");
            wle.setErrorMessage("Unsupported configuration for XML parser.");
            throw new ProcessException("Unsupported configuration for XML parser.", wle, (Throwable)pce);
        }
        try {
            doc = builder.parse(file);
        }
        catch (SAXException saxe) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E0");
            wle.setErrorMessage("Unexpected error when trying to parse xml resource.");
            throw new ProcessException("Unexpected error when trying to parse xml resource.", wle, (Throwable)saxe);
        }
        catch (IOException ioe) {
            WebLabException wle = new WebLabException();
            wle.setErrorId("E3");
            wle.setErrorMessage("Content not available");
            throw new ProcessException("Unable to parse retrieved content.", wle, (Throwable)ioe);
        }
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        Text text = null;
        Annotation annot = AnnotationFactory.createAndLinkAnnotation((Resource)cu);
        ResourceHelper rh = RDFHelperFactory.getResourceHelper((Resource)cu);
        PoKHelper h = RDFHelperFactory.getPoKHelper((PieceOfKnowledge)annot);
        h.setAutoCommitMode(false);
        for (XmlProperty xmlProperty : this.conf.getPropertyList()) {
            Object result;
            try {
                XPathExpression expr = xpath.compile(xmlProperty.getXpathExpression());
                result = expr.evaluate(doc, XPathConstants.NODESET);
            }
            catch (XPathExpressionException xpee) {
                WebLabException wle = new WebLabException();
                wle.setErrorId("E3");
                wle.setErrorMessage("Content not available for xpath expression: " + xmlProperty.getXpathExpression());
                throw new ProcessException("Unable to parse retrieved content.", wle, (Throwable)xpee);
            }
            NodeList nodes = (NodeList)result;
            for (int i = 0; i < nodes.getLength(); ++i) {
                logger.debug((Object)("node value: " + nodes.item(i).getNodeValue()));
                for (String propertyURI : xmlProperty.getNormalisedPropertyURI()) {
                    if (this.conf.isInOverrrideMode() || !this.conf.isInOverrrideMode() && rh.getLitsOnPredSubj(cu.getUri(), propertyURI).size() == 0 && rh.getRessOnPredSubj(cu.getUri(), propertyURI).size() == 0) {
                        if (xmlProperty.getNormalisedPropertyType().equals((Object)XmlProperty.NormalisedPropertyType.LITERAL)) {
                            h.createLitStat(cu.getUri(), propertyURI, nodes.item(i).getNodeValue());
                            continue;
                        }
                        if (!xmlProperty.getNormalisedPropertyType().equals((Object)XmlProperty.NormalisedPropertyType.RESOURCE)) continue;
                        h.createResStat(cu.getUri(), propertyURI, nodes.item(i).getNodeValue());
                        continue;
                    }
                    logger.info((Object)("Property \"" + propertyURI + "\" is already present on Resource and 'override mode' is disabled."));
                }
                if (!xmlProperty.isAppendValuesToTextUnit()) continue;
                if (text == null) {
                    text = (Text)MediaUnitFactory.createAndLinkMediaUnit((ComposedUnit)cu, Text.class);
                }
                if (text.getContent() != null) {
                    text.setContent(text.getContent() + nodes.item(i).getNodeValue() + "\n");
                    continue;
                }
                text.setContent(nodes.item(i).getNodeValue() + "\n");
            }
        }
        h.commit();
        pr.setResource((Resource)cu);
        return pr;
    }

    protected static ComposedUnit checkArgs(ProcessArgs args) throws ProcessException {
        WebLabException wle = new WebLabException();
        wle.setErrorId("E1");
        wle.setErrorMessage("Invalid parameter.");
        if (args == null) {
            throw new ProcessException("ProcessArgs was null.", wle);
        }
        Resource res = args.getResource();
        if (res == null) {
            throw new ProcessException("Resource of ProcessArgs was null.", wle);
        }
        if (!(res instanceof ComposedUnit)) {
            throw new ProcessException("Resource of ProcessArgs was not a ComposedUnit, but a " + res.getClass().getName() + ".", wle);
        }
        return (ComposedUnit)res;
    }

    public NormaliserConfig getConf() {
        return this.conf;
    }

    public void setConf(NormaliserConfig conf) {
        this.conf = conf;
    }

    static {
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.add("application/xml");
        tempList.add("application/rdf+xml");
        tempList.add("application/rss+xml");
        XML_TYPES = Collections.unmodifiableList(tempList);
    }
}

