/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.api.abstractElmt;

import java.net.URI;
import java.util.Map;
import java.util.logging.Logger;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.schema.impl.Constants;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLImportException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractDescriptionImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInclude;

public abstract class AbstractIncludeImpl<E, D extends AbsItfDescription>
extends AbstractWSDLElementImpl<E>
implements AbsItfInclude<D> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(AbstractIncludeImpl.class.getName());
    protected D desc;

    public AbstractIncludeImpl(E model, D parent, Map<URI, AbsItfDescription> descriptionImports, Map<URI, AbsItfSchema> schemaImports, URI baseURI, AbstractWSDLReaderImpl reader) throws WSDLException, WSDLImportException {
        super(model, (AbstractWSDLElementImpl)parent);
        this.parent = (AbstractSchemaElementImpl)parent;
        URI location = this.getLocationURI();
        if (this.parent != null) {
            if (!((AbstractDescriptionImpl)this.parent).getFeatures().isEmpty()) {
                if (((AbstractDescriptionImpl)this.parent).getFeatures().get((Object)WSDLReader.FeatureConstants.IMPORT_DOCUMENTS) != null && ((Boolean)((AbstractDescriptionImpl)this.parent).getFeatures().get((Object)WSDLReader.FeatureConstants.IMPORT_DOCUMENTS)).booleanValue()) {
                    this.retrieveInclude(location, baseURI, descriptionImports, schemaImports, reader);
                } else if (descriptionImports != null && descriptionImports.get(location) != null) {
                    this.desc = descriptionImports.get(location);
                }
            } else if (descriptionImports != null && descriptionImports.get(location) != null) {
                this.desc = descriptionImports.get(location);
            }
        }
        if (this.parent != null && this.desc != null && this.desc instanceof AbstractDescriptionImpl) {
            ((AbstractDescriptionImpl)this.desc).setFeatures(reader.getFeatures());
        }
    }

    private void retrieveInclude(URI originalWsdlLocation, URI baseURI, Map<URI, AbsItfDescription> descriptionImports, Map<URI, AbsItfSchema> schemaImports, AbstractWSDLReaderImpl reader) throws WSDLException, WSDLImportException {
        if (originalWsdlLocation != null) {
            try {
                URI wsdlLocation = null;
                wsdlLocation = Constants.XML_URI.equals(originalWsdlLocation) ? this.getClass().getClassLoader().getResource("schema/xml.xsd").toURI().normalize() : originalWsdlLocation;
                String locationNorm = wsdlLocation.normalize().toString();
                if (reader.getImportList().containsKey(locationNorm)) {
                    LOG.warning("This import is already include : " + locationNorm + ". This probably mean there's a cyclic import");
                    this.desc = reader.getImportList().get(locationNorm);
                } else {
                    if (descriptionImports != null && descriptionImports.containsKey(wsdlLocation)) {
                        this.desc = descriptionImports.get(wsdlLocation);
                    } else {
                        reader.getImportList().put(locationNorm, null);
                        this.desc = reader.readExternalPart(wsdlLocation, baseURI, descriptionImports, schemaImports, false);
                    }
                    reader.getImportList().put(locationNorm, (AbsItfDescription)this.desc);
                }
            }
            catch (Exception e) {
                throw new WSDLImportException("the imported document cannot be imported at: " + originalWsdlLocation, e);
            }
        }
    }

    @Override
    public D getDescription() {
        return this.desc;
    }

    @Override
    public void setDescription(D d) {
        this.desc = d;
    }

    public D getParentDescription() {
        return (D)((AbsItfDescription)((Object)this.parent));
    }

    public void setParentDescription(D p) {
        this.parent = (AbstractSchemaElementImpl)p;
    }
}

