/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.api.abstractElmt;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.absItf.AbsItfImport;
import org.ow2.easywsdl.schema.api.absItf.AbsItfInclude;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.wsdl.api.Part;
import org.ow2.easywsdl.wsdl.api.Types;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractInterfaceTypeImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractOperationImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractParamImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfParam;
import org.ow2.easywsdl.wsdl.impl.wsdl11.MessageImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.TypesImpl;

public abstract class AbstractPartImpl<E>
extends AbstractWSDLElementImpl<E>
implements Part {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(AbstractPartImpl.class.getName());
    protected QName elementName;
    protected QName typeName;

    public AbstractPartImpl(E model, AbstractWSDLElementImpl parent) {
        super(model, parent);
    }

    public AbsItfParam getParam() {
        AbsItfParam param = null;
        if (this.parent instanceof AbstractParamImpl) {
            param = (AbsItfParam)((Object)this.parent);
        }
        return param;
    }

    @Override
    public Element getElement() {
        Element res = null;
        Object item = null;
        AbsItfDescription desc = null;
        if (this.parent instanceof AbstractParamImpl) {
            desc = ((AbstractInterfaceTypeImpl)((AbstractOperationImpl)((AbstractParamImpl)this.parent).getOperation()).getInterface()).getDescription();
        }
        if (this.parent instanceof MessageImpl) {
            desc = ((MessageImpl)this.parent).getDescription();
        }
        if (this.elementName != null) {
            List<Element> elmts = this.findElementsInAllSchema(desc, this.elementName);
            if (elmts.size() == 1) {
                res = elmts.get(0);
            }
            if (elmts.size() > 1) {
                LOG.warning("several same elements exists: optimistic result => take the first element");
                res = elmts.get(0);
            }
        }
        return res;
    }

    private List<? extends Element> findElementsInAllSchema(AbsItfDescription desc, QName element) {
        ArrayList res = new ArrayList();
        if (desc != null && element != null) {
            for (AbsItfSchema schema : desc.getTypes().getSchemas()) {
                res.addAll(schema.findElementsInAllSchema(element));
                for (AbsItfImport imptSchema : schema.getImports()) {
                    if (imptSchema.getSchema() != null) {
                        res.addAll(imptSchema.getSchema().findElementsInAllSchema(element));
                        continue;
                    }
                    LOG.severe("No schema linked to the import with namespace: " + imptSchema.getNamespaceURI());
                }
                for (AbsItfInclude inclSchema : schema.getIncludes()) {
                    if (inclSchema.getSchema() == null) continue;
                    res.addAll(inclSchema.getSchema().findElementsInAllSchema(element));
                }
            }
            for (AbsItfSchema schema : desc.getTypes().getImportedSchemas()) {
                if (schema == null) continue;
                res.addAll(schema.findElementsInAllSchema(element));
            }
            for (org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfImport impt : desc.getImports()) {
                if (impt == null) continue;
                res.addAll(this.findElementsInAllSchema((AbsItfDescription)impt.getDescription(), element));
            }
        }
        return res;
    }

    @Override
    public Type getType() {
        Type res = null;
        Type item = null;
        AbsItfDescription desc = null;
        if (this.parent instanceof AbstractParamImpl) {
            desc = ((AbstractInterfaceTypeImpl)((AbstractOperationImpl)((AbstractParamImpl)this.parent).getOperation()).getInterface()).getDescription();
        }
        if (this.parent instanceof MessageImpl) {
            desc = ((MessageImpl)this.parent).getDescription();
        }
        Types types = (Types)desc.getTypes();
        if (this.typeName != null) {
            if (types != null && types.getSchemas() != null) {
                for (Schema schema : types.getSchemas()) {
                    item = (Type)schema.getType(this.typeName);
                    if (item == null) continue;
                    res = item;
                    break;
                }
            }
            if (res == null && (item = SchemaFactory.getDefaultSchema().getType(this.typeName)) != null) {
                res = item;
            }
            if (res == null && (item = (Type)TypesImpl.getSoap11encTypesSchema().getType(this.typeName)) != null) {
                res = item;
            }
            if (res == null && (item = (Type)TypesImpl.getSoap12encTypesSchema().getType(this.typeName)) != null) {
                res = item;
            }
        }
        return res;
    }
}

