/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.List;
import java.util.Map;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.runtime.BpelExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sequence
extends AbstractBpelActivity {
    private static final long serialVersionUID = 1L;

    @Override
    public void executeActivity(BpelExecution execution) {
        NodeImpl node = execution.getNode();
        if (!node.isPreviousNeeded()) {
            throw new OrchestraRuntimeException("behaviour " + Sequence.class.getName() + " requires that node.isPreviousNeeded() is set to true");
        }
        Node firstNode = (Node)node.getNodes().get(0);
        execution.createExecution().execute(firstNode);
    }

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        if (signal == null) {
            NodeImpl node = execution.getNode();
            List nestedNodes = node.getNodes();
            Node previousNode = execution.getPreviousNode();
            int nextNodeIndex = nestedNodes.indexOf(previousNode) + 1;
            execution.end("ended");
            BpelExecution sequenceExecution = execution.getParent();
            sequenceExecution.removeExecution((Execution)execution);
            if (nestedNodes.size() == nextNodeIndex) {
                sequenceExecution.signal("finished");
            } else {
                Node nextNode = (Node)nestedNodes.get(nextNodeIndex);
                sequenceExecution.createExecution().execute(nextNode);
            }
        } else if (signal.equals("finished")) {
            this.afterRunned(execution);
        }
    }

    @Override
    public ActivityType getType() {
        return ActivityType.SEQUENCE;
    }
}

