/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ow2.orchestra.env.EnvironmentResourcesLoader;
import org.ow2.orchestra.env.binding.ChainerBinding;
import org.ow2.orchestra.env.binding.ImplementationBinding;
import org.ow2.orchestra.env.binding.OrchestraRetryInterceptorBinding;
import org.ow2.orchestra.env.binding.QuerierDbSessionBinding;
import org.ow2.orchestra.env.binding.QuerierListAccessorBinding;
import org.ow2.orchestra.env.binding.RuntimeDbSessionBinding;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.env.PvmEnvironmentFactory;
import org.ow2.orchestra.pvm.internal.env.PvmEnvironmentFactoryParser;
import org.ow2.orchestra.pvm.internal.xml.Binding;
import org.ow2.orchestra.pvm.internal.xml.Bindings;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.util.Misc;
import org.xml.sax.InputSource;

public class BpelEnvironmentParser
extends PvmEnvironmentFactoryParser {
    private static final String ENVIRONMENT_ORCHESTRA_XSD = "environment-orchestra.xsd";
    public static final String CLASSPATH_URL = "classpath://";

    public BpelEnvironmentParser() {
        Bindings bindings = this.getEnvironmentXmlParser().getBindings();
        this.getEnvironmentFactoryXmlParser().setBindings(bindings);
        bindings.addBinding((Binding)new RuntimeDbSessionBinding());
        bindings.addBinding((Binding)new QuerierDbSessionBinding());
        bindings.addBinding((Binding)new ImplementationBinding("repository"));
        bindings.addBinding((Binding)new ImplementationBinding("invoker"));
        bindings.addBinding((Binding)new ImplementationBinding("publisher"));
        bindings.addBinding((Binding)new ImplementationBinding("recorder"));
        bindings.addBinding((Binding)new ImplementationBinding("journal"));
        bindings.addBinding((Binding)new ImplementationBinding("finished-instance-handler"));
        bindings.addBinding((Binding)new ImplementationBinding("undeployed-process-handler"));
        bindings.addBinding((Binding)new ChainerBinding());
        bindings.addBinding((Binding)new ImplementationBinding("history"));
        bindings.addBinding((Binding)new ImplementationBinding("archiver"));
        bindings.addBinding((Binding)new ImplementationBinding("dead-job-handler"));
        bindings.addBinding((Binding)new QuerierListAccessorBinding());
        bindings.addBinding((Binding)new OrchestraRetryInterceptorBinding());
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public static BpelEnvironmentParser getInstance() {
        return new BpelEnvironmentParser();
    }

    public static EnvironmentFactory parseEnvironmentFactoryFromXmlString(String xmlString) {
        Parse parse = BpelEnvironmentParser.getInstance().createParse();
        EnvironmentFactory factory = (EnvironmentFactory)parse.setString(xmlString).execute().getDocumentObject();
        parse.checkProblems("environment");
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized EnvironmentFactory parseEnvironmentFactoryFromURL(URL url) {
        ClassLoader oldClassLoader;
        if (url == null) {
            throw new OrchestraRuntimeException("No environment xml found");
        }
        ClassLoader newClassLoader = oldClassLoader = Thread.currentThread().getContextClassLoader();
        URL dirUrl = null;
        try {
            dirUrl = url.toURI().resolve("./").toURL();
        }
        catch (MalformedURLException e) {
            Misc.unreachableStatement();
        }
        catch (URISyntaxException e) {
            Misc.unreachableStatement();
        }
        if (dirUrl != null) {
            newClassLoader = AccessController.doPrivileged(new CreateEnvironmentClassLoaderAction(oldClassLoader, dirUrl));
        }
        Thread.currentThread().setContextClassLoader(newClassLoader);
        try {
            Parse parse = BpelEnvironmentParser.getInstance().createParse();
            PvmEnvironmentFactory factory = (PvmEnvironmentFactory)parse.setUrl(url).execute().getDocumentObject();
            parse.checkProblems("environment");
            factory.getEnvironmentFactoryCtxWireContext().setClassLoader(newClassLoader);
            factory.getEnvironmentCtxWireDefinition().setClassLoader(newClassLoader);
            PvmEnvironmentFactory pvmEnvironmentFactory = factory;
            return pvmEnvironmentFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public static synchronized EnvironmentFactory parseEnvironmentFactoryFromResource(String resource) {
        Misc.checkArgsNotNull((Object[])new Object[]{resource});
        Parse parse = BpelEnvironmentParser.getInstance().createParse();
        EnvironmentFactory factory = (EnvironmentFactory)parse.setResource(resource).execute().getDocumentObject();
        parse.checkProblems("environment");
        return factory;
    }

    public synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        this.documentBuilderFactory = this.newDocumentBuilderFactory();
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setValidating(true);
        this.documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        URL url = Thread.currentThread().getContextClassLoader().getResource(ENVIRONMENT_ORCHESTRA_XSD);
        Misc.badStateIfNull((Object)url, (String)"Ouch! Can't get the Orchestra environment XML Schema. I was looking for a resource called: environment-orchestra.xsd which is usally provided within the Orchestra distribution.");
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", url.toExternalForm());
        return this.documentBuilderFactory;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId.startsWith(CLASSPATH_URL)) {
            String localpart = systemId.substring(CLASSPATH_URL.length());
            InputStream inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(localpart);
            if (inStream != null) {
                return new InputSource(inStream);
            }
        }
        return super.resolveEntity(publicId, systemId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CreateEnvironmentClassLoaderAction
    implements PrivilegedAction<URLClassLoader> {
        private final ClassLoader oldClassLoader;
        private final URL dirUrl;

        private CreateEnvironmentClassLoaderAction(ClassLoader oldClassLoader, URL dirUrl) {
            this.oldClassLoader = oldClassLoader;
            this.dirUrl = dirUrl;
        }

        @Override
        public URLClassLoader run() {
            return new EnvironmentResourcesLoader(this.dirUrl, this.oldClassLoader);
        }
    }
}

