/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.runtime.full.impl;

import java.util.Date;
import org.ow2.orchestra.facade.runtime.VariableUpdate;
import org.ow2.orchestra.facade.runtime.impl.VariableUpdateImpl;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VariableUpdateFullImpl
implements VariableUpdate {
    private static final long serialVersionUID = 4978973329065042473L;
    protected long dbid;
    private ActivityInstanceUUID activityUUID;
    private Date date;
    private String name;
    protected MessageVariable messageValue;
    protected Document xmlValue;

    protected VariableUpdateFullImpl() {
    }

    public VariableUpdateFullImpl(VariableUpdate record) {
        this(record.getActivityUUID(), new Date(record.getDate().getTime()), record.getName(), record.getValue());
    }

    public VariableUpdateFullImpl(ActivityInstanceUUID activityUUID, Date date, String name, Object value) {
        this.activityUUID = activityUUID;
        this.date = new Date(date.getTime());
        this.name = name;
        if (value != null) {
            if (value instanceof MessageVariable) {
                this.messageValue = ((MessageVariable)value).duplicate();
            } else if (value instanceof Element) {
                this.xmlValue = XmlUtil.getNewDocument();
                Node n = this.xmlValue.importNode((Node)value, true);
                this.xmlValue.appendChild(n);
            } else {
                Misc.unreachableStatement((String)"unknow variable type");
            }
        }
    }

    public ActivityInstanceUUID getActivityUUID() {
        return this.activityUUID;
    }

    public Date getDate() {
        return this.date;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        if (this.messageValue != null && !this.messageValue.getParts().isEmpty()) {
            return this.messageValue;
        }
        if (this.xmlValue == null) {
            return null;
        }
        return this.xmlValue.getDocumentElement();
    }

    public String toString() {
        return "Update " + this.name + " at " + this.date + " by " + this.activityUUID + " to value [" + this.getValue() + "]";
    }

    public VariableUpdate copy() {
        return new VariableUpdateImpl((VariableUpdate)this);
    }
}

