/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.def.impl.ProcessDefinitionImpl;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindProcessDefinitionsCommand
implements Command<List<ProcessDefinition>> {
    private static final long serialVersionUID = 7939041300740473575L;
    private final ProcessState state;
    private final QName processName;

    public FindProcessDefinitionsCommand(ProcessState state, QName processName) {
        this.state = state;
        this.processName = processName;
    }

    public FindProcessDefinitionsCommand(ProcessState state) {
        this.state = state;
        this.processName = null;
    }

    public FindProcessDefinitionsCommand(QName processName) {
        this.state = null;
        this.processName = processName;
    }

    public FindProcessDefinitionsCommand() {
        this.state = null;
        this.processName = null;
    }

    public List<ProcessDefinition> execute(Environment environment) {
        ArrayList<ProcessDefinition> result = new ArrayList<ProcessDefinition>();
        Querier querier = EnvTool.getQuerier();
        List<ProcessFullDefinition> processFullDefinitions = this.processName != null && this.state != null ? querier.findProcessDefinitions(this.processName, this.state) : (this.processName != null ? querier.findProcessDefinitions(this.processName) : (this.state != null ? querier.findProcessDefinitions(this.state) : querier.findProcessDefinitions()));
        for (ProcessFullDefinition processFullDefinition : processFullDefinitions) {
            result.add((ProcessDefinition)new ProcessDefinitionImpl((ProcessDefinition)processFullDefinition));
        }
        return result;
    }
}

