/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.lang.jaxen;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.VariableContext;
import org.jaxen.expr.Expr;
import org.jaxen.expr.LocationPath;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.lang.evaluator.PropertyQueryEvaluator;
import org.ow2.orchestra.lang.jaxen.BpelVariableContext;
import org.ow2.orchestra.lang.jaxen.XPathEvaluator;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Node;

class XPathPropertyQueryEvaluator
extends XPathEvaluator
implements PropertyQueryEvaluator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(XPathPropertyQueryEvaluator.class.getName());
    private static final FunctionContext FUNCTION_LIBRARY = XPathEvaluator.readFunctionLibrary();

    XPathPropertyQueryEvaluator(String text) throws JaxenException {
        super(text);
    }

    public Node evaluate(Node contextNode, BpelExecution bpelExecution) {
        try {
            Context context = this.getContext(contextNode, bpelExecution);
            List nodeSet = this.selectNodes(context);
            return this.narrowToSingleNode(nodeSet);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "query evaluation failed", e);
            throw BpelFaultException.generateBpelFaultException((BpelFaultException.BpelFault)BpelFaultException.BpelFault.subLanguageExecutionFault);
        }
    }

    public void assign(Node contextNode, Object value, BpelExecution bpelExecution, boolean keepSrcEltName) {
        Expr expr = this.getRootExpr();
        Context context = this.getContext(contextNode, bpelExecution);
        try {
            List nodeSet = expr instanceof LocationPath ? this.selectOrCreateNodes((LocationPath)expr, context) : this.selectNodes(context);
            BpelXmlUtil.setObjectValue(this.narrowToSingleNode(nodeSet), value, keepSrcEltName);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "query assignment failed", e);
            throw BpelFaultException.generateBpelFaultException((BpelFaultException.BpelFault)BpelFaultException.BpelFault.subLanguageExecutionFault);
        }
    }

    protected FunctionContext createFunctionContext() {
        return FUNCTION_LIBRARY;
    }

    private Context getContext(Node contextNode, BpelExecution bpelExecution) {
        ContextSupport support = this.getContextSupport();
        support.setVariableContext((VariableContext)new BpelVariableContext(bpelExecution));
        Context context = new Context(support);
        context.setNodeSet(Collections.singletonList(contextNode));
        return context;
    }
}

