/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing;

import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.parsing.BasicHandler;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BasicFileParser {
    protected abstract String getSchema();

    public Object parseAndSetObject(Object target, InputStream inputStream) {
        try {
            BasicHandler handler = new BasicHandler(target);
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL schemaUrl = this.getClass().getClassLoader().getResource(this.getSchema());
            Schema schema = schemaFactory.newSchema(schemaUrl);
            parserFactory.setSchema(schema);
            parserFactory.setNamespaceAware(true);
            SAXParser saxParser = parserFactory.newSAXParser();
            saxParser.parse(inputStream, (DefaultHandler)handler);
            return handler.getResult();
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }
}

