/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.activity.Compensate;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.ActivityDefinition;
import org.ow2.orchestra.facade.def.full.BpelActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.CompensateActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.parsing.binding.ActivityBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.pvm.activity.ExternalActivity;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.w3c.dom.Element;

public class CompensateBinding
extends ActivityBinding {
    private static Logger log = Logger.getLogger(CompensateBinding.class.getName());

    public CompensateBinding() {
        super("compensate", ActivityType.COMPENSATE);
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        Compensate compensate = new Compensate();
        this.setEnclosingScope(compensate, parse);
        this.parseStandardAttributes(element, compensate, parse);
        this.parseStandardElements(element, compensate, parse);
        NodeImpl activityNode = this.createActivityNode(element, parse, parser, (ExternalActivity)compensate);
        boolean foundFHorCHorTH = false;
        DefinitionKeeper definitionKeeper = (DefinitionKeeper)parse.findObject(DefinitionKeeper.class);
        for (Object e : definitionKeeper.getParentsStack()) {
            ActivityDefinition parentActivity = (ActivityDefinition)e;
            ActivityType parentActivityType = parentActivity.getType();
            if (parentActivityType != ActivityType.CATCH_HANDLER && parentActivityType != ActivityType.CATCHALL_HANDLER && parentActivityType != ActivityType.COMPENSATION_HANDLER && parentActivityType != ActivityType.TERMINATION_HANDLER) continue;
            foundFHorCHorTH = true;
            break;
        }
        if (!foundFHorCHorTH) {
            String message = StaticAnalysisFault.getMessage("SA00007", "  The <compensate> element \"" + compensate.getName() + "\" is not in a <catch>, <catchAll>, <compensationHandler> or <terminationHandler> element.");
            parse.addProblem(message, (Exception)((Object)new StaticAnalysisException("SA00007")));
            return null;
        }
        return activityNode;
    }

    public BpelActivityFullDefinition createActivityFullDefinition(ProcessDefinitionUUID processDefinitionUUID, ActivityDefinitionUUID activityDefinitionUUID, String name, Parse parse) {
        return new CompensateActivityFullDefinitionImpl(processDefinitionUUID, activityDefinitionUUID, name);
    }
}

