/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.activity.extensions.Test;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.parsing.binding.ActivityBinding;
import org.ow2.orchestra.pvm.activity.ExternalActivity;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class ExtensionActivityBinding
extends ActivityBinding {
    private static Logger log = Logger.getLogger(ExtensionActivityBinding.class.getName());

    public ExtensionActivityBinding() {
        super("extensionActivity", ActivityType.EXTENSION_ACTIVITY);
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        List childrenElements;
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        if ((childrenElements = XmlUtil.elements((Element)element)).size() > 1) {
            throw new OrchestraRuntimeException("Only one Element is expected a s a child of extensionActivity");
        }
        Element extensionActivityToParse = (Element)childrenElements.get(0);
        if ("http://orchestra.ow2.org".equals(extensionActivityToParse.getNamespaceURI()) && "test".equals(extensionActivityToParse.getLocalName())) {
            return this.parseTest(extensionActivityToParse, parse, parser);
        }
        parse.addProblem("Unknown ExtensionActivity : " + element.getNamespaceURI() + ":" + element.getLocalName());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseTest(Element element, Parse parse, Parser parser) {
        Test testVarObject = new Test();
        NodeImpl testVarNode = this.createActivityNode(element, parse, parser, (ExternalActivity)testVarObject);
        this.setEnclosingScope(testVarObject, parse);
        this.parseStandardAttributes(element, testVarObject, parse);
        this.parseStandardElements(element, testVarObject, parse);
        parse.pushObject((Object)testVarNode);
        parse.pushObject((Object)testVarObject);
        try {
            String plnkNamesAttr;
            String varNamesAttr = XmlUtil.attribute((Element)element, (String)"varNames");
            if (varNamesAttr != null) {
                ArrayList<String> varNames = new ArrayList<String>();
                for (String s : varNamesAttr.split(",")) {
                    varNames.add(s.trim());
                }
                testVarObject.setVarNames(varNames);
            }
            if ((plnkNamesAttr = XmlUtil.attribute((Element)element, (String)"plnkNames")) != null) {
                ArrayList<String> plnkNames = new ArrayList<String>();
                for (String s : plnkNamesAttr.split(",")) {
                    plnkNames.add(s.trim());
                }
                testVarObject.setPlnkNames(plnkNames);
            }
            String event = XmlUtil.attribute((Element)element, (String)"event");
            testVarObject.setEvent(event);
        }
        finally {
            parse.popObject();
            parse.popObject();
        }
        return testVarNode;
    }
}

