/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.EventHandlerActivity;
import org.ow2.orchestra.definition.activity.Invoke;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.From;
import org.ow2.orchestra.definition.element.FromPart;
import org.ow2.orchestra.definition.element.PartnerLink;
import org.ow2.orchestra.definition.element.To;
import org.ow2.orchestra.definition.element.ToPart;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.FromPartDefinition;
import org.ow2.orchestra.facade.def.ToPartDefinition;
import org.ow2.orchestra.facade.def.Variant;
import org.ow2.orchestra.facade.def.full.InvokeActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.ScopeActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.TerminationHandlerFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.InvokeActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.FromPartDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.ToPartDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.parsing.binding.ActivityWithFCTHBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.parsing.binding.ImplicitScopeBinding;
import org.ow2.orchestra.parsing.binding.exception.CorrelationSetNotFoundException;
import org.ow2.orchestra.pvm.activity.Activity;
import org.ow2.orchestra.pvm.activity.ExternalActivity;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeBinding
extends ActivityWithFCTHBinding {
    private static Logger log = Logger.getLogger(InvokeBinding.class.getName());
    private final ImplicitScopeBinding surroundingScopeInvokeBinding = new ImplicitScopeBinding();

    public InvokeBinding() {
        super("invoke", ActivityType.INVOKE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(Element element, Parse parse, Parser parser) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        DefinitionKeeper definitionKeeper = (DefinitionKeeper)parse.findObject(DefinitionKeeper.class);
        Scope scope = new Scope();
        this.setEnclosingScope(scope, parse);
        this.surroundingScopeInvokeBinding.parseStandardAttributes(element, scope, parse);
        ScopeActivityFullDefinition scopeActivityFullDefinition = (ScopeActivityFullDefinition)definitionKeeper.getActivityFullDefinition();
        NodeImpl scopeNode = this.createActivityNode("null", parse, parser, (ExternalActivity)scope);
        scope.setScopeNode(scopeNode);
        parse.pushObject((Object)scope);
        parse.pushObject((Object)scopeNode);
        try {
            BpelProcess bpelProcess;
            Operation operation;
            QName portType;
            definitionKeeper.pushParent();
            Invoke invoke = new Invoke();
            this.createActivityNode(element, parse, parser, (ExternalActivity)invoke);
            EventHandlerActivity activity = new EventHandlerActivity();
            scopeNode.createNode("eventHandler_" + scopeNode.getName()).setBehaviour((Activity)activity);
            ProcessDefinitionUUID processDefinitionUUID = definitionKeeper.getProcessFullDefinition().getUUID();
            ActivityDefinitionUUID activityDefinitionUUID = new ActivityDefinitionUUID(processDefinitionUUID, definitionKeeper.getNextActivityCount(), activity.getType(), activity.getName());
            activity.setUuid(activityDefinitionUUID);
            TerminationHandlerFullDefinition terminationHandlerDefinition = this.addDefaultTH(parse, scopeNode);
            scopeActivityFullDefinition.setTerminationHandler(terminationHandlerDefinition);
            this.parseCompensation(element, parse, parser, scopeNode, scopeActivityFullDefinition);
            this.parseCatchAndCatchAll(element, parse, parser, scopeNode, scopeActivityFullDefinition);
            this.setEnclosingScope(invoke, parse);
            this.parseStandardAttributes(element, invoke, parse);
            this.parseStandardElements(element, scope, parse);
            InvokeActivityFullDefinition invokeActivityFullDefinition = (InvokeActivityFullDefinition)definitionKeeper.getActivityFullDefinition();
            scope.setName("surroundingInvoke_" + invoke.getUuid());
            scopeNode.setName(this.getNodeName(Scope.class.getSimpleName(), "surroundingInvoke_" + invoke.getUuid()));
            String partnerLinkName = XmlUtil.attribute((Element)element, (String)"partnerLink");
            invoke.setPartnerLink(partnerLinkName);
            String operationSt = XmlUtil.attribute((Element)element, (String)"operation");
            invoke.setOperation(operationSt);
            String inputVariable = XmlUtil.attribute((Element)element, (String)"inputVariable");
            invoke.setInputVariable(inputVariable);
            String outputVariable = XmlUtil.attribute((Element)element, (String)"outputVariable");
            invoke.setOutputVariable(outputVariable);
            invokeActivityFullDefinition.setPartnerLink(partnerLinkName);
            invokeActivityFullDefinition.setInputVariable(inputVariable);
            invokeActivityFullDefinition.setOutputVariable(outputVariable);
            invokeActivityFullDefinition.setOperation(operationSt);
            PartnerLink partnerLink = this.findPartnerLinkDefinition(parse, partnerLinkName);
            if (partnerLink == null) {
                parse.addProblem("No partnerLink " + partnerLinkName + " defined.");
                Object var19_19 = null;
                return var19_19;
            }
            QName plportType = partnerLink.getPartnerRolePortTypeQName();
            if (plportType == null) {
                parse.addProblem("No partnerRole defined for partnerLink: " + partnerLinkName);
                Object var20_21 = null;
                return var20_21;
            }
            invoke.setPortTypeQName(plportType);
            invokeActivityFullDefinition.setPortType(plportType);
            if (XmlUtil.attribute((Element)element, (String)"portType") != null && !plportType.equals(portType = XmlUtil.attributeQName((Element)element, (String)"portType"))) {
                String message = StaticAnalysisFault.getMessage("SA00005", "  invoke " + invoke.getName() + " has specified a PortType that is different from the one specified by the partnerLink");
                parse.addProblem(message, (Exception)((Object)new StaticAnalysisException("SA00005")));
            }
            Element fromPartsElement = XmlUtil.element((Element)element, (String)"fromParts");
            List fromPartElements = null;
            if (fromPartsElement != null) {
                fromPartElements = XmlUtil.elements((Element)fromPartsElement, (String)"fromPart");
                if (invoke.getOutputVariable() != null) {
                    String message = StaticAnalysisFault.getMessage("SA00052", "  invoke " + invoke.getName() + " has specified both an outputVariable and a fromPart");
                    parse.addProblem(message, (Exception)((Object)new StaticAnalysisException("SA00052")));
                }
            }
            Element toPartsElement = XmlUtil.element((Element)element, (String)"toParts");
            List toPartElements = null;
            if (toPartsElement != null) {
                toPartElements = XmlUtil.elements((Element)toPartsElement, (String)"toPart");
                if (invoke.getInputVariable() != null) {
                    String message = StaticAnalysisFault.getMessage("SA00051", "  invoke " + invoke.getName() + " has specified both an inputVariable and a toPart");
                    parse.addProblem(message, (Exception)((Object)new StaticAnalysisException("SA00051")));
                }
            }
            if ((operation = (bpelProcess = (BpelProcess)((Object)parse.findObject(BpelProcess.class))).getWsdlInfos().getPortType(invoke.getPortTypeQName()).getOperation(invoke.getOperation(), null, null)) == null) {
                parse.addProblem("No operation " + invoke.getOperation() + " defined for port type " + invoke.getPortTypeQName());
                Object var26_28 = null;
                return var26_28;
            }
            QName inputMessageQName = null;
            if (operation.getInput() != null) {
                inputMessageQName = operation.getInput().getMessage().getQName();
            }
            QName outputMessageQName = null;
            if (operation.getOutput() != null) {
                outputMessageQName = operation.getOutput().getMessage().getQName();
                if (fromPartElements == null && invoke.getOutputVariable() == null) {
                    parse.addProblem("Cannot define Invoke one way " + invoke.getName() + " on a two way operation " + operation.getName());
                }
                invoke.setOneWay(false);
            } else {
                invoke.setOneWay(true);
            }
            Element correlationsElement = XmlUtil.element((Element)element, (String)"correlations");
            if (correlationsElement != null) {
                List correlationElements = XmlUtil.elements((Element)correlationsElement, (String)"correlation");
                this.parseCorrelations(correlationElements, invoke, parse);
            }
            this.setOutCopies(toPartElements, invoke, inputMessageQName, invokeActivityFullDefinition);
            this.setInCopies(fromPartElements, invoke, outputMessageQName, invokeActivityFullDefinition);
        }
        finally {
            parse.popObject();
            parse.popObject();
            definitionKeeper.popParent();
        }
        return scopeNode;
    }

    private void setOutCopies(List<Element> toPartElements, Invoke invoke, QName inputMessageQName, InvokeActivityFullDefinition invokeActivityFullDefinition) {
        Variable anonymousOutboundMessageVariable = new Variable();
        anonymousOutboundMessageVariable.setName("ORCHESTRA_4_OUTBOUND_WSDL_MESSAGE");
        anonymousOutboundMessageVariable.setMessageType(inputMessageQName);
        invoke.setAnonymousOutboundMessageVariable(anonymousOutboundMessageVariable);
        String anonymousOutboundMessageVariableName = anonymousOutboundMessageVariable.getName();
        String inputVariable = invoke.getInputVariable();
        ArrayList<Copy> outCopies = new ArrayList<Copy>();
        if (inputVariable != null) {
            From from = new From();
            from.setVariable(inputVariable);
            from.setVariant(Variant.VAR);
            To to = new To();
            to.setVariable(anonymousOutboundMessageVariableName);
            to.setVariant(Variant.VAR);
            Copy copy = new Copy();
            copy.setFrom(from);
            copy.setTo(to);
            outCopies.add(copy);
        } else {
            ArrayList<ToPart> toParts = new ArrayList<ToPart>();
            if (toPartElements != null) {
                for (Element toPartElement : toPartElements) {
                    ToPart toPart = new ToPart();
                    String part = XmlUtil.attribute((Element)toPartElement, (String)"part");
                    toPart.setPart(part);
                    String fromVariable = XmlUtil.attribute((Element)toPartElement, (String)"fromVariable");
                    toPart.setFromVariable(fromVariable);
                    invokeActivityFullDefinition.addToPartDefinition((ToPartDefinition)new ToPartDefinitionImpl(fromVariable, part));
                    toParts.add(toPart);
                }
            }
            for (ToPart toPart : toParts) {
                From from = new From();
                from.setVariable(toPart.getFromVariable());
                from.setVariant(Variant.VAR);
                To to = new To();
                to.setVariable(anonymousOutboundMessageVariableName);
                to.setPart(toPart.getPart());
                to.setVariant(Variant.VAR);
                Copy copy = new Copy();
                copy.setFrom(from);
                copy.setTo(to);
                outCopies.add(copy);
            }
        }
        if (outCopies.size() != 0) {
            invoke.setOutCopies(outCopies);
        }
    }

    private void setInCopies(List<Element> fromPartElements, Invoke invoke, QName outputMessageQName, InvokeActivityFullDefinition invokeActivityFullDefinition) {
        String outputVariable = invoke.getOutputVariable();
        ArrayList<Copy> inCopies = new ArrayList<Copy>();
        if (!invoke.isOneWay()) {
            Variable anonymousInboundMessageVariable = new Variable();
            anonymousInboundMessageVariable.setName("ORCHESTRA_4_INBOUND_WSDL_MESSAGE");
            anonymousInboundMessageVariable.setMessageType(outputMessageQName);
            invoke.setAnonymousInboundMessageVariable(anonymousInboundMessageVariable);
            String anonymousInboundMessageVariableName = anonymousInboundMessageVariable.getName();
            if (outputVariable != null) {
                From from = new From();
                from.setVariable(anonymousInboundMessageVariableName);
                from.setVariant(Variant.VAR);
                To to = new To();
                to.setVariable(outputVariable);
                to.setVariant(Variant.VAR);
                Copy copy = new Copy();
                copy.setFrom(from);
                copy.setTo(to);
                inCopies.add(copy);
            } else {
                Object toVariable;
                ArrayList<FromPart> fromParts = new ArrayList<FromPart>();
                if (fromPartElements != null) {
                    for (Element fromPartElement : fromPartElements) {
                        FromPart fromPart = new FromPart();
                        String part = XmlUtil.attribute((Element)fromPartElement, (String)"part");
                        fromPart.setPart(part);
                        toVariable = XmlUtil.attribute((Element)fromPartElement, (String)"toVariable");
                        fromPart.setToVariable((String)toVariable);
                        invokeActivityFullDefinition.addFromPartDefinition((FromPartDefinition)new FromPartDefinitionImpl(part, (String)toVariable));
                        fromParts.add(fromPart);
                    }
                }
                for (FromPart fromPart : fromParts) {
                    From from = new From();
                    from.setVariable(anonymousInboundMessageVariableName);
                    from.setPart(fromPart.getPart());
                    from.setVariant(Variant.VAR);
                    To to = new To();
                    to.setVariable(fromPart.getToVariable());
                    to.setVariant(Variant.VAR);
                    toVariable = invoke.getEnclosingScope().findVariable(fromPart.getToVariable());
                    if (((Variable)((Object)toVariable)).getMessageType() != null) {
                        to.setPart(fromPart.getPart());
                    }
                    Copy copy = new Copy();
                    copy.setFrom(from);
                    copy.setTo(to);
                    inCopies.add(copy);
                }
            }
        }
        if (inCopies.size() != 0) {
            invoke.setInCopies(inCopies);
        }
    }

    private void parseCorrelations(List<Element> correlationElements, Invoke invoke, Parse parse) {
        ArrayList<Correlation> requestCorrelations = new ArrayList<Correlation>();
        ArrayList<Correlation> responseCorrelations = new ArrayList<Correlation>();
        if (correlationElements != null) {
            for (Element correlationElement : correlationElements) {
                Correlation correlation = new Correlation();
                String set = XmlUtil.attribute((Element)correlationElement, (String)"set");
                Scope enclosingScope = invoke.getEnclosingScope();
                try {
                    correlation.setCorrelationSet(enclosingScope.findCorrelationSet(set));
                }
                catch (CorrelationSetNotFoundException e) {
                    parse.addProblem("A correlation has not been defined in enclosing scopes", (Exception)e);
                }
                String initiate = XmlUtil.attribute((Element)correlationElement, (String)"initiate");
                correlation.setInitiate(initiate);
                if (invoke.isOneWay()) {
                    requestCorrelations.add(correlation);
                    continue;
                }
                String pattern = XmlUtil.attribute((Element)correlationElement, (String)"pattern");
                if ("request".equals(pattern) || "request-response".equals(pattern)) {
                    requestCorrelations.add(correlation);
                }
                if (!"response".equals(pattern) && !"request-response".equals(pattern)) continue;
                responseCorrelations.add(correlation);
            }
        }
        invoke.setRequestCorrelations(requestCorrelations);
        invoke.setResponseCorrelations(responseCorrelations);
    }

    @Override
    public InvokeActivityFullDefinition createActivityFullDefinition(ProcessDefinitionUUID processDefinitionUUID, ActivityDefinitionUUID activityDefinitionUUID, String name, Parse parse) {
        return new InvokeActivityFullDefinitionImpl(processDefinitionUUID, activityDefinitionUUID, name);
    }
}

