/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.logging.Logger;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.pvm.internal.model.ExceptionHandlerImpl;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.model.ProcessElementImpl;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultInCHHandler
extends ExceptionHandlerImpl {
    private static final long serialVersionUID = 6330814889501735922L;
    private static Logger log = Logger.getLogger(FaultInCHHandler.class.getName());

    public boolean matches(Class<?> exceptionClass) {
        return BpelFaultException.class.isAssignableFrom(exceptionClass);
    }

    protected void executeHandler(ExecutionImpl execution, Exception exception, ProcessElementImpl processElementImpl) {
        BpelExecution chBpelExecution;
        NodeImpl chNode = (NodeImpl)processElementImpl;
        BpelExecution bpelExecution = (BpelExecution)execution;
        BpelFaultException bpelFault = (BpelFaultException)((Object)exception);
        EnvTool.getRecorder().recordExceptionOccured(bpelExecution.getActivityInstanceUUID(), bpelFault);
        for (chBpelExecution = bpelExecution; chBpelExecution != null && chBpelExecution.getNode() != chNode; chBpelExecution = chBpelExecution.getParent()) {
        }
        if (chBpelExecution == null || chBpelExecution.getNode() != chNode) {
            Misc.unreachableStatement((String)("Cannot find the bpelExecution for compensation handler " + chNode));
        }
        ScopeRuntime scopeRuntime = chBpelExecution.getCurrentScopeRuntime();
        log.finest("Handling exception " + exception + " in BpelExecution " + (Object)((Object)bpelExecution) + ": scopeRuntime state is " + scopeRuntime.getState() + ", CHBpelExecution is " + (Object)((Object)chBpelExecution));
        if (!ScopeState.COMPENSATING.equals((Object)scopeRuntime.getState())) {
            Misc.unreachableStatement((String)("The compensation handler " + chNode + " is in invalid state " + scopeRuntime.getState()));
        }
        scopeRuntime.setLastException(bpelFault.fullCopy());
        chBpelExecution.terminate();
    }
}

