/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.Hashtable;
import java.util.Map;
import org.ow2.orchestra.definition.element.Link;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.LinkRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowRuntime {
    protected long dbid;
    protected Map<String, LinkRuntime> linkRuntimes;

    protected FlowRuntime() {
    }

    public FlowRuntime(Map<String, Link> links, ActivityInstanceUUID flowActivityInstanceUUID) {
        this.linkRuntimes = new Hashtable<String, LinkRuntime>();
        if (links != null) {
            for (String linkName : links.keySet()) {
                this.linkRuntimes.put(linkName, new LinkRuntime(linkName, flowActivityInstanceUUID));
            }
        }
    }

    public LinkRuntime getLink(String linkName) {
        return this.linkRuntimes.get(linkName);
    }

    public Boolean getLinkStatus(String linkName) {
        return this.linkRuntimes.get(linkName).getStatus();
    }

    public void setLinkStatus(String linkName, Boolean status) {
        this.linkRuntimes.get(linkName).setStatus(status);
    }

    public boolean hasLink(String linkName) {
        return this.linkRuntimes.containsKey(linkName);
    }

    public BpelExecution getWaitingExecution(String linkName) {
        LinkRuntime lr = this.linkRuntimes.get(linkName);
        if (lr != null) {
            BpelExecution waitingExecution = lr.getWaitingExecution();
            if (waitingExecution != null) {
                lr.setWaitingExecution(null);
            }
            return waitingExecution;
        }
        return null;
    }

    public void addWaitingExecution(String linkName, BpelExecution waitingExecution) {
        this.linkRuntimes.get(linkName).setWaitingExecution(waitingExecution);
    }
}

