/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.element.PartnerLink;
import org.ow2.orchestra.facade.data.runtime.PartnerLinkUpdateData;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.runtime.PartnerLinkUpdateType;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.wsdl.WsdlsInfos;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PartnerLinkRuntime {
    private static Logger log = Logger.getLogger(PartnerLinkRuntime.class.getName());
    protected long dbid;
    protected ActivityInstanceUUID scopeActivityInstanceUUID;
    protected String name;
    protected PartnerLink partnerLinkDefinition;
    private Element partnerRoleEndPointReference;
    private Element myRoleEndPointReference;

    protected PartnerLinkRuntime() {
    }

    public PartnerLinkRuntime(PartnerLink partnerLinkDefinition, BpelExecution execution, ActivityInstanceUUID scopeActivityInstanceUUID) {
        this.scopeActivityInstanceUUID = scopeActivityInstanceUUID;
        this.name = partnerLinkDefinition.getName();
        this.partnerLinkDefinition = partnerLinkDefinition;
        if (partnerLinkDefinition.getMyRolePortTypeQName() != null) {
            this.initializeMyRole(execution);
        }
        if (partnerLinkDefinition.getPartnerRolePortTypeQName() != null) {
            this.initializePartnerRole(execution);
        }
    }

    public void initializePartnerRole(BpelExecution execution) {
        Port defaultPort = null;
        QName expectedPortTypeQName = this.partnerLinkDefinition.getPartnerRolePortTypeQName();
        WsdlsInfos wsdlsInfos = execution.getProcessDefinition().getWsdlInfos();
        List<Port> ports = wsdlsInfos.getPorts(this.partnerLinkDefinition.getPartnerRolePortTypeQName());
        try {
            HashMap<Port, SOAPAddress> supported = new HashMap<Port, SOAPAddress>();
            for (Port port : ports) {
                List elements = port.getExtensibilityElements();
                if (elements.size() > 0) {
                    for (ExtensibilityElement element : elements) {
                        if (!(element instanceof SOAPAddress)) {
                            log.warning("The extensibility element: " + element.getElementType() + " is currently not supported!");
                            continue;
                        }
                        if (!port.getBinding().getPortType().getQName().equals(expectedPortTypeQName)) continue;
                        supported.put(port, (SOAPAddress)element);
                    }
                    continue;
                }
                supported.put(port, null);
            }
            SOAPAddress soapAddress = null;
            Service service = null;
            if (supported.entrySet() != null && supported.entrySet().size() > 0) {
                Map.Entry entry = supported.entrySet().iterator().next();
                defaultPort = (Port)entry.getKey();
                soapAddress = (SOAPAddress)entry.getValue();
                log.finest("Using the supported port: " + defaultPort);
                service = execution.getServiceOfPort(defaultPort);
            }
            if (service != null) {
                Document document = BpelUtil.getServiceRefDocument(soapAddress, service.getQName());
                this.partnerRoleEndPointReference = document.getDocumentElement();
            }
            EnvTool.getRecorder().recordPartnerLinkUpdated(new PartnerLinkUpdateData(execution.getActivityInstanceUUID(), execution.getActivityInstanceUUID(), this.name, PartnerLinkUpdateType.PARTNER_ROLE_INITITIALIZED, this.partnerRoleEndPointReference));
        }
        catch (Exception e) {
            if (ports == null || defaultPort == null) {
                log.fine("You have to defined a defaut port for partnerRole, which bind the portType of the partnerLink");
            }
            log.log(Level.WARNING, "Exception thrown during initializePartnerRole()", e);
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    public void initializeMyRole(BpelExecution execution) {
        block2: {
            Port defaultPort = null;
            WsdlsInfos wsdlsInfos = execution.getProcessDefinition().getWsdlInfos();
            try {
                defaultPort = wsdlsInfos.getPorts(this.partnerLinkDefinition.getMyRolePortTypeQName()).get(0);
                Service service = execution.getServiceOfPort(defaultPort);
                List elements = defaultPort.getExtensibilityElements();
                SOAPAddress soapAddress = (SOAPAddress)BpelUtil.findExtensibilityElement(elements, SOAPAddress.class);
                this.myRoleEndPointReference = BpelUtil.getServiceRefDocument(soapAddress, service.getQName()).getDocumentElement();
                EnvTool.getRecorder().recordPartnerLinkUpdated(new PartnerLinkUpdateData(execution.getActivityInstanceUUID(), execution.getActivityInstanceUUID(), this.name, PartnerLinkUpdateType.MY_ROLE_INITITIALIZED, this.myRoleEndPointReference));
            }
            catch (Exception e) {
                if (wsdlsInfos.getPorts(this.partnerLinkDefinition.getMyRolePortTypeQName()) != null && defaultPort != null || !log.isLoggable(Level.FINE)) break block2;
                log.fine("You have to defined a defaut port myRole, which bind the portType of the partnerLink");
            }
        }
    }

    public Element getMyRoleEndPointReference() {
        return this.myRoleEndPointReference;
    }

    public void setMyRoleEndPointReference(Element myRoleEndPointReference) {
        this.myRoleEndPointReference = myRoleEndPointReference;
    }

    public Element getPartnerRoleEndPointReference() {
        return this.partnerRoleEndPointReference;
    }

    public void setPartnerRoleEndPointReference(Element partnerRoleEndPointReference, ActivityInstanceUUID activityInstanceUUID) {
        this.partnerRoleEndPointReference = partnerRoleEndPointReference;
        EnvTool.getRecorder().recordPartnerLinkUpdated(new PartnerLinkUpdateData(this.scopeActivityInstanceUUID, activityInstanceUUID, this.name, PartnerLinkUpdateType.PARTNER_ROLE_UPDATED, this.partnerRoleEndPointReference));
    }

    public String getName() {
        return this.name;
    }

    public PartnerLink getPartnerLinkDefinition() {
        return this.partnerLinkDefinition;
    }

    public long getDbid() {
        return this.dbid;
    }
}

