/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services;

import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.ExecElementToSignal;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.PendingMessage;
import org.ow2.orchestra.services.Receiver;
import org.ow2.orchestra.services.SignalExecUtil;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.var.MessageVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncAssociateMessage
implements Command<BpelExecution> {
    protected OperationKey operationKey;
    protected MessageVariable incomingMessage;
    protected MessageCarrier messageCarrier;

    public AsyncAssociateMessage(OperationKey operationKey, MessageVariable incomingMessage, MessageCarrier messageCarrier) {
        this.operationKey = operationKey;
        this.incomingMessage = incomingMessage;
        this.messageCarrier = messageCarrier;
    }

    public BpelExecution execute(Environment environment) {
        Repository repository = EnvTool.getRepository();
        BpelProcess bpelProcess = null;
        bpelProcess = repository.lockProcess(this.operationKey.getProcessUUID());
        Receiver receiver = bpelProcess.getReceiver(this.operationKey);
        if (receiver == null) {
            throw new OrchestraRuntimeException("impossible to find a receiver corresponding to: " + this.operationKey);
        }
        PendingMessage pendingMessage = receiver.storeIncomingMessage(this.incomingMessage, this.messageCarrier);
        ExecElementToSignal newExecElt = receiver.associatePendingMessage(pendingMessage, bpelProcess);
        if (newExecElt != null) {
            SignalExecUtil.execute(environment, newExecElt.getBpelExecution(), newExecElt.getReceivingElement(), newExecElt.getPendingMessage());
        } else {
            receiver.storePendingMessage(pendingMessage);
        }
        return newExecElt != null ? newExecElt.getBpelExecution() : null;
    }
}

