/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;

public class OperationKey
implements Serializable {
    private static final long serialVersionUID = 7629200185946199717L;
    protected ProcessDefinitionUUID processUUID;
    protected QName portTypeQName;
    protected String operationName;

    protected OperationKey() {
    }

    public OperationKey(ProcessDefinitionUUID processUUID, QName portTypeQName, String operationName) {
        this.processUUID = processUUID;
        this.portTypeQName = portTypeQName;
        this.operationName = operationName;
    }

    public OperationKey(OperationKey operationKey) {
        this.processUUID = operationKey.getProcessUUID();
        this.portTypeQName = operationKey.getPortTypeQName();
        this.operationName = operationKey.getOperationName();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OperationKey)) {
            return false;
        }
        OperationKey other = (OperationKey)o;
        return this.processUUID.equals((Object)other.getProcessUUID()) && this.portTypeQName.equals(other.getPortTypeQName()) && this.operationName.equals(other.getOperationName());
    }

    public int hashCode() {
        int hashcode = 13;
        hashcode += hashcode * 37 + this.processUUID.hashCode();
        hashcode += hashcode * 37 + this.portTypeQName.hashCode();
        hashcode += hashcode * 37 + this.operationName.hashCode();
        return hashcode;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public QName getPortTypeQName() {
        return this.portTypeQName;
    }

    public ProcessDefinitionUUID getProcessUUID() {
        return this.processUUID;
    }

    public String toString() {
        return "[" + this.processUUID + "|" + this.portTypeQName + "|" + this.operationName + "]";
    }
}

