/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services;

import java.util.HashMap;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.MessageCarrierRepository;
import org.ow2.orchestra.services.PendingMessage;
import org.ow2.orchestra.services.ReceivingElement;

public final class SignalExecUtil {
    public static final String RECEIVING_ELEMENT_PARAM = "receivingElement";
    public static final String MESSAGE_PARAM = "message";
    public static final String MESSAGE_CARRIER_PARAM = "messageCarrier";

    private SignalExecUtil() {
    }

    public static void execute(Environment environment, BpelExecution exec, ReceivingElement recvElt, PendingMessage pendingMessage) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(RECEIVING_ELEMENT_PARAM, recvElt);
        parameters.put(MESSAGE_PARAM, pendingMessage.getMessage().duplicate());
        if (pendingMessage.getMessageCarrierId() != null) {
            MessageCarrier messageCarrier = MessageCarrierRepository.removePendingMessageCarrier(pendingMessage.getMessageCarrierId());
            if (messageCarrier == null) {
                throw new OrchestraRuntimeException("Message carrier " + pendingMessage.getMessageCarrierId() + " not found !");
            }
            parameters.put(MESSAGE_CARRIER_PARAM, messageCarrier);
        }
        exec.signal(parameters);
    }
}

