/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.services.Archivable;
import org.ow2.orchestra.services.Archiver;
import org.ow2.orchestra.services.Recorder;

public abstract class ArchiveTool {
    private ArchiveTool() {
    }

    public static void atomicArchive(Archivable archivable, Recorder recorder, Archiver archiver) {
        try {
            archiver.archive(archivable);
        }
        catch (Exception e) {
            throw new AtomicArchiveException("Can't archive archivable: " + archivable + " into archiver: " + archiver, e);
        }
        try {
            recorder.remove(archivable);
        }
        catch (Exception e) {
            throw new AtomicArchiveException("Can't remove archivable: " + archivable + " from history: " + recorder, e);
        }
    }

    public static class AtomicArchiveException
    extends OrchestraRuntimeException {
        public AtomicArchiveException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

