/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.util.DatatypeUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class BpelXmlUtil {
    static final String QUALIFIED_VALUE_PREFIX = "valueNS";
    private static final Logger LOG = Logger.getLogger(BpelXmlUtil.class.getName());
    private static final boolean TRACE_ENABLED = LOG.isLoggable(Level.FINEST);

    private BpelXmlUtil() {
    }

    public static boolean nodeNameEquals(Node node, String namespaceURI, String localName) {
        return BpelXmlUtil.nodeNamespaceURIEquals(node, namespaceURI) && localName.equals(node.getLocalName());
    }

    public static boolean nodeNamespaceURIEquals(Node node, String namespaceURI) {
        String nodeNamespaceURI = node.getNamespaceURI();
        return nodeNamespaceURI == null || nodeNamespaceURI.length() == 0 ? namespaceURI == null || namespaceURI.length() == 0 : nodeNamespaceURI.equals(namespaceURI);
    }

    public static void setObjectValue(Node node, Object value, boolean keepSrcElementName) {
        switch (node.getNodeType()) {
            case 1: {
                BpelXmlUtil.setObjectValue((Element)node, value, keepSrcElementName);
                break;
            }
            case 9: {
                BpelXmlUtil.setObjectValue(((Document)node).getDocumentElement(), value, keepSrcElementName);
                break;
            }
            default: {
                String nil;
                if (value instanceof Element && Boolean.TRUE.equals(DatatypeUtil.parseBoolean(nil = ((Element)value).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil")))) {
                    throw BpelFaultException.generateBpelFaultException((BpelFaultException.BpelFault)BpelFaultException.BpelFault.selectionFailure);
                }
                node.setNodeValue(DatatypeUtil.toString(value));
            }
        }
    }

    public static void setObjectValue(Element elem, Object value, boolean keepSrcElementName) {
        if (value instanceof Node) {
            switch (((Node)value).getNodeType()) {
                case 1: {
                    BpelXmlUtil.copy(elem, (Element)value, keepSrcElementName);
                    break;
                }
                case 9: {
                    BpelXmlUtil.copy(elem, ((Document)value).getDocumentElement(), keepSrcElementName);
                    break;
                }
                default: {
                    BpelXmlUtil.setStringValue(elem, ((Node)value).getNodeValue());
                    break;
                }
            }
        } else {
            BpelXmlUtil.setStringValue(elem, DatatypeUtil.toString(value));
        }
    }

    public static void setStringValue(Element elem, String value) {
        elem.removeAttributeNS("urn:orchestra.org:bpel-2.0", "initialized");
        Node firstChild = elem.getFirstChild();
        if (firstChild instanceof Text) {
            firstChild.setNodeValue(value);
        } else {
            firstChild = elem.getOwnerDocument().createTextNode(value);
        }
        BpelXmlUtil.removeChildNodes(elem);
        elem.appendChild(firstChild);
    }

    public static String toTraceString(Element elem) {
        String namespace = elem.getNamespaceURI();
        String localName = elem.getLocalName();
        if (namespace == null || namespace.length() == 0) {
            return localName;
        }
        StringBuffer traceBuffer = new StringBuffer(namespace.length() + localName.length());
        traceBuffer.append('{').append(namespace).append('}');
        String prefix = elem.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            traceBuffer.append(prefix).append(':');
        }
        return traceBuffer.append(localName).toString();
    }

    public static void copy(Element target, Element source, boolean keepSrcElementName) {
        if (TRACE_ENABLED) {
            LOG.finest("copying from: " + BpelXmlUtil.toTraceString(source));
        }
        if (keepSrcElementName || BpelXmlUtil.isDefaultElement(target)) {
            Node parentNode = target.getParentNode();
            Document doc = target.getOwnerDocument();
            Element newTarget = doc.createElementNS(source.getNamespaceURI(), source.getTagName());
            parentNode.replaceChild(newTarget, target);
            target = newTarget;
        }
        BpelXmlUtil.removeAttributes(target);
        BpelXmlUtil.copyAttributes(target, source);
        BpelXmlUtil.copyVisibleNamespaces(target, source);
        BpelXmlUtil.ensureOwnNamespaceDeclared(target);
        BpelXmlUtil.removeChildNodes(target);
        BpelXmlUtil.copyChildNodes(target, source);
        if (TRACE_ENABLED) {
            LOG.finest("copied to: " + BpelXmlUtil.toTraceString(target));
        }
    }

    public static void copyVisibleNamespaces(Element target, Element source) {
        BpelXmlUtil.copyNamespaces(target, source);
        Node parent = source.getParentNode();
        while (parent instanceof Element) {
            BpelXmlUtil.copyNamespaces(target, (Element)parent);
            parent = parent.getParentNode();
        }
    }

    public static void copyNamespaces(Element target, Element source) {
        if (!source.hasAttributes()) {
            return;
        }
        NamedNodeMap attributes = source.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Node attribute = attributes.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(attribute.getNamespaceURI())) continue;
            String namespaceURI = attribute.getNodeValue();
            String prefix = attribute.getLocalName();
            if ("xmlns".equals(prefix)) {
                if ("".equals(BpelXmlUtil.getPrefix(namespaceURI, target))) continue;
                BpelXmlUtil.addNamespaceDeclaration(target, namespaceURI);
                if (!TRACE_ENABLED) continue;
                LOG.finest("added default namespace declaration: " + namespaceURI);
                continue;
            }
            if (prefix.equals(BpelXmlUtil.getPrefix(namespaceURI, target))) continue;
            BpelXmlUtil.addNamespaceDeclaration(target, namespaceURI, prefix);
            if (!TRACE_ENABLED) continue;
            LOG.finest("added namespace declaration: " + prefix + "->" + namespaceURI);
        }
    }

    public static void copyAttributes(Element target, Element source) {
        if (!source.hasAttributes()) {
            return;
        }
        NamedNodeMap attributes = source.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Node sourceAttr = attributes.item(i);
            String namespaceURI = sourceAttr.getNamespaceURI();
            String name = sourceAttr.getNodeName();
            if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) continue;
            if (namespaceURI == null || namespaceURI.length() == 0) {
                target.setAttribute(name, sourceAttr.getNodeValue());
                if (!TRACE_ENABLED) continue;
                LOG.finest("set attribute: " + name);
                continue;
            }
            Attr targetAttr = target.getOwnerDocument().createAttributeNS(namespaceURI, name);
            targetAttr.setValue(sourceAttr.getNodeValue());
            target.setAttributeNodeNS(targetAttr);
            BpelXmlUtil.ensureNamespaceDeclared(targetAttr, namespaceURI, sourceAttr.getPrefix());
            if (!TRACE_ENABLED) continue;
            LOG.finest("set attribute: {" + namespaceURI + '}' + name);
        }
    }

    public static void copyChildNodes(Element target, Element source) {
        Document targetDoc = target.getOwnerDocument();
        block4: for (Node child = source.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: {
                    BpelXmlUtil.copyChildElement(target, (Element)child);
                    continue block4;
                }
                case 3: 
                case 4: {
                    target.appendChild(targetDoc.createTextNode(child.getNodeValue()));
                    if (!TRACE_ENABLED) continue block4;
                    LOG.finest("appended text: " + child.getNodeValue());
                    continue block4;
                }
                default: {
                    LOG.finest("discarding child: " + child);
                }
            }
        }
    }

    public static void copyChildElement(Element parent, Element source) {
        Element target = (Element)parent.getOwnerDocument().importNode(source, true);
        parent.appendChild(target);
        BpelXmlUtil.ensureOwnNamespaceDeclared(target);
        if (TRACE_ENABLED) {
            LOG.finest("appended element: " + BpelXmlUtil.toTraceString(target));
        }
    }

    public static void ensureNamespaceDeclared(Attr attribute, String namespaceURI, String prefix) {
        if (prefix == null || prefix.length() == 0) {
            throw new IllegalArgumentException("prefix cannot be empty");
        }
        if (namespaceURI == null || namespaceURI.length() == 0) {
            throw new IllegalArgumentException("namespaceURI cannot be empty");
        }
        Element element = attribute.getOwnerElement();
        if (!prefix.equals(BpelXmlUtil.getPrefix(namespaceURI, element))) {
            BpelXmlUtil.addNamespaceDeclaration(element, namespaceURI, prefix);
        }
    }

    public static void ensureNamespaceDeclared(Element element, String namespaceURI, String prefix) {
        if (prefix == null || prefix.length() == 0) {
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            if (!"".equals(BpelXmlUtil.getPrefix(namespaceURI, element))) {
                BpelXmlUtil.addNamespaceDeclaration(element, namespaceURI);
            }
        } else {
            if (namespaceURI == null || namespaceURI.length() == 0) {
                throw new IllegalArgumentException("namespaceURI cannot be empty unless prefix is empty");
            }
            if (!prefix.equals(BpelXmlUtil.getPrefix(namespaceURI, element))) {
                BpelXmlUtil.addNamespaceDeclaration(element, namespaceURI, prefix);
            }
        }
    }

    public static void ensureOwnNamespaceDeclared(Element elem) {
        BpelXmlUtil.ensureNamespaceDeclared(elem, elem.getNamespaceURI(), elem.getPrefix());
    }

    public static void addNamespaceDeclaration(Element elem, String namespaceURI) {
        elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceURI);
    }

    public static void addNamespaceDeclaration(Element elem, String namespaceURI, String prefix) {
        elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespaceURI);
    }

    public static void removeAttributes(Element elem) {
        if (elem.hasAttributes()) {
            int i;
            NamedNodeMap attributeMap = elem.getAttributes();
            int n = attributeMap.getLength();
            Attr[] attributes = new Attr[n];
            for (i = 0; i < n; ++i) {
                attributes[i] = (Attr)attributeMap.item(i);
            }
            for (i = 0; i < n; ++i) {
                elem.removeAttributeNode(attributes[i]);
            }
        }
    }

    public static void removeChildNodes(Node node) {
        Node current = node.getFirstChild();
        while (current != null) {
            Node next = current.getNextSibling();
            node.removeChild(current);
            current = next;
        }
    }

    public static Element createElement(QName name) {
        String namespace = name.getNamespaceURI();
        String localName = name.getLocalPart();
        if (namespace.length() == 0) {
            return BpelXmlUtil.createElement(localName);
        }
        String prefix = name.getPrefix();
        return BpelXmlUtil.createElement(namespace, prefix.length() > 0 ? prefix + ':' + localName : localName);
    }

    public static Element createElement(String namespaceURI, String prefixedName) {
        Document doc = XmlUtil.getNewDocument();
        Element elem = doc.createElementNS(namespaceURI, prefixedName);
        doc.appendChild(elem);
        BpelXmlUtil.ensureOwnNamespaceDeclared(elem);
        return elem;
    }

    public static Element createElement(String localName) {
        Document doc = XmlUtil.getNewDocument();
        Element elem = doc.createElementNS(null, localName);
        doc.appendChild(elem);
        return elem;
    }

    public static String getPrefix(String namespaceURI, Node contextNode) {
        switch (contextNode.getNodeType()) {
            case 2: {
                contextNode = ((Attr)contextNode).getOwnerElement();
                break;
            }
            case 1: {
                break;
            }
            default: {
                contextNode = contextNode.getParentNode();
            }
        }
        while (contextNode != null && contextNode.getNodeType() == 1) {
            NamedNodeMap attributes = contextNode.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Node attr = attributes.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !namespaceURI.equals(attr.getNodeValue())) continue;
                String prefix = attr.getLocalName();
                return "xmlns".equals(prefix) ? "" : prefix;
            }
            contextNode = contextNode.getParentNode();
        }
        return null;
    }

    public static Element createDefaultElement() {
        return BpelXmlUtil.createElementWithContent(null);
    }

    public static Element createElementWithContent(String data) {
        Document document = XmlUtil.getNewDocument();
        Element defaultElement = document.createElementNS("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "Orchestra_BPEL_Prefix:ORCHESTRA_anonymous_element");
        defaultElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:Orchestra_BPEL_Prefix", "http://docs.oasis-open.org/wsbpel/2.0/process/executable");
        document.appendChild(defaultElement);
        if (data != null) {
            defaultElement.setTextContent(data);
        }
        return defaultElement;
    }

    public static boolean isDefaultElement(Element element) {
        if (element == null) {
            return false;
        }
        return "http://docs.oasis-open.org/wsbpel/2.0/process/executable".equals(element.getNamespaceURI()) && "ORCHESTRA_anonymous_element".equals(element.getLocalName());
    }
}

