/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DbTool {
    private DbTool() {
    }

    public static String generateScript(String create, String envXml, String confName, Dialect dialect) throws MalformedURLException, ClassNotFoundException {
        Document doc = XmlUtil.getDocumentFromString((String)envXml);
        NodeList nl = doc.getElementsByTagName("hibernate-configuration");
        Configuration configuration = new Configuration();
        for (int i = 0; i < nl.getLength(); ++i) {
            List mappingElts;
            Element confElt = (Element)nl.item(i);
            if (!confName.equals(XmlUtil.attribute((Element)confElt, (String)"name"))) continue;
            List mappingsElts = XmlUtil.elements((Element)confElt, (String)"mappings");
            if (mappingsElts != null) {
                for (Element element : mappingsElts) {
                    String resourceName = XmlUtil.attribute((Element)element, (String)"resource");
                    Document doc2 = XmlUtil.getDocumentFromInputStream((InputStream)ReflectUtil.getResourceAsStream(null, (String)resourceName));
                    List mappingElts2 = XmlUtil.elements((Element)doc2.getDocumentElement(), (String)"mapping");
                    if (mappingElts2 == null) continue;
                    for (Element elt : mappingElts2) {
                        DbTool.addMapping(configuration, elt);
                    }
                }
            }
            if ((mappingElts = XmlUtil.elements((Element)confElt, (String)"mapping")) == null) continue;
            for (Element element : mappingElts) {
                DbTool.addMapping(configuration, element);
            }
        }
        String[] string = null;
        if (create.equals("create")) {
            string = configuration.generateSchemaCreationScript(dialect);
        } else if (create.equals("drop")) {
            string = configuration.generateDropSchemaScript(dialect);
        } else {
            throw new IllegalArgumentException("Invalid type: " + create + ", only 'create' or 'drop' allowed");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String s : string) {
            stringBuffer.append(s).append(';').append(Misc.LINE_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    private static void addMapping(Configuration configuration, Element element) throws ClassNotFoundException, MalformedURLException {
        if (element.hasAttribute("resource")) {
            String resource = element.getAttribute("resource");
            configuration.addResource(resource);
        } else if (element.hasAttribute("file")) {
            String fileName = element.getAttribute("file");
            configuration.addFile(fileName);
        } else if (element.hasAttribute("class")) {
            String className = element.getAttribute("class");
            configuration.addClass(Class.forName(className));
        } else if (element.hasAttribute("url")) {
            String urlText = element.getAttribute("url");
            configuration.addURL(new URL(urlText));
        } else {
            Misc.unreachableStatement();
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, IOException {
        switch (args.length) {
            case 2: {
                Dialect dialect = (Dialect)ReflectUtil.instantiate(null, (String)args[1]);
                System.out.println(DbTool.generateScript(args[0], new DefaultEnvXMLGenerator(null, DefaultEnvXMLGenerator.InstallationType.INTERNAL_JOURNAL_WITH_HISTORY).createEnvironmentXml(), "hibernate-configuration:core", dialect));
                break;
            }
            case 3: {
                Dialect dialect = (Dialect)ReflectUtil.instantiate(null, (String)args[1]);
                String s = DbTool.generateScript(args[0], new DefaultEnvXMLGenerator(null, DefaultEnvXMLGenerator.InstallationType.INTERNAL_JOURNAL_WITH_HISTORY).createEnvironmentXml(), "hibernate-configuration:core", dialect);
                Misc.write((String)s, (File)new File(args[2]));
                break;
            }
            case 4: {
                Dialect dialect = (Dialect)ReflectUtil.instantiate(null, (String)args[1]);
                String s = DbTool.generateScript(args[0], new DefaultEnvXMLGenerator(null, DefaultEnvXMLGenerator.InstallationType.INTERNAL_JOURNAL_WITH_HISTORY).createEnvironmentXml(), args[3], dialect);
                Misc.write((String)s, (File)new File(args[2]));
                break;
            }
            case 5: {
                Dialect dialect = (Dialect)ReflectUtil.instantiate(null, (String)args[1]);
                String s = DbTool.generateScript(args[0], new String(Misc.getAllContentFrom((File)new File(args[4]))), args[3], dialect);
                Misc.write((String)s, (File)new File(args[2]));
                break;
            }
            default: {
                throw new OrchestraRuntimeException("Invalid syntax: " + DbTool.class.getName() + " dialectClass [outputFile [hibernateConfigName [environmentFileName]]]");
            }
        }
    }
}

