/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.persistence.QuerierDbSession;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.session.TimerSession;
import org.ow2.orchestra.services.Archiver;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.services.Recorder;
import org.ow2.orchestra.services.impl.QuerierListAccessor;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnvTool {
    private EnvTool() {
    }

    private static Environment getEnv() {
        Environment environment = Environment.getCurrent();
        Misc.badStateIfNull((Object)environment, (String)"Environment is null!");
        return environment;
    }

    private static <T> T getEnvClass(Class<T> clazz) {
        Environment environment = EnvTool.getEnv();
        Object object = environment.get(clazz);
        if (object == null) {
            throw new OrchestraRuntimeException("No object of class " + clazz.getName() + " found in environment!");
        }
        return (T)object;
    }

    private static <T> T getEnvObject(Class<T> clazz, String name) {
        Environment environment = EnvTool.getEnv();
        Misc.badStateIfNull((Object)environment, (String)"Environment is null!");
        Object object = environment.get(name);
        if (object == null) {
            throw new OrchestraRuntimeException("No object named " + name + " found in environment!");
        }
        if (!clazz.isInstance(object)) {
            throw new OrchestraRuntimeException("Object: " + object + " named: " + name + " found in environment is not an instance of class " + clazz.getName() + "!");
        }
        return (T)object;
    }

    public static Repository getRepository() {
        return EnvTool.getEnvClass(Repository.class);
    }

    public static Recorder getRecorder() {
        return EnvTool.getEnvObject(Recorder.class, "recorder");
    }

    public static Querier getQuerier() {
        return EnvTool.getQuerierListAccessor().getAllQueriers();
    }

    public static Archiver getArchiver() {
        return EnvTool.getEnvObject(Archiver.class, "archiver");
    }

    private static QuerierListAccessor getQuerierListAccessor() {
        return EnvTool.getEnvObject(QuerierListAccessor.class, "queryList");
    }

    public static Querier getJournalQueriers() {
        return EnvTool.getQuerierListAccessor().getJournals();
    }

    public static Querier getHistoryQueriers() {
        return EnvTool.getQuerierListAccessor().getHistories();
    }

    public static <T> T get(Class<T> class1, String key) {
        Misc.checkArgsNotNull((Object[])new Object[]{class1, key});
        Object o = EnvTool.getEnv().get(key);
        Misc.badStateIfNull((Object)o, (String)("Object '" + key + "' can't be found in environment"));
        Misc.badStateIfFalse((boolean)class1.isAssignableFrom(o.getClass()), (String)("Object got from environment is not an instance of " + class1 + ". It is  : " + o.getClass()));
        return (T)o;
    }

    public static TimerSession getTimerSession() {
        return EnvTool.getEnvClass(TimerSession.class);
    }

    public static QuerierDbSession getQuerierDbSession(String id) {
        return EnvTool.getEnvObject(QuerierDbSession.class, id);
    }
}

