/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.env;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnvironmentHelper {
    private static Map<Class<?>, Object> defaultObjectCache = new HashMap();

    private EnvironmentHelper() {
    }

    public static <T> T get(Class<T> type) {
        if (type == null) {
            return null;
        }
        Environment environment = Environment.getCurrent();
        if (environment != null) {
            return environment.get(type);
        }
        if (defaultObjectCache.containsKey(type)) {
            return (T)defaultObjectCache.get(type);
        }
        try {
            Method defaultFactoryMethod = type.getMethod("createDefault", new Class[0]);
            if (defaultFactoryMethod != null) {
                Object defaultObject = defaultFactoryMethod.invoke(null, new Object[0]);
                defaultObjectCache.put(type, defaultObject);
                return (T)defaultObject;
            }
        }
        catch (Exception e) {
            throw new PvmException("couldn't create default " + type.getName(), e);
        }
        return null;
    }
}

