/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.deploy;

import org.ow2.orchestra.pvm.Deployment;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.client.ClientProcessDefinition;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.deploy.Deployer;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.model.ProcessDefinitionImpl;
import org.ow2.orchestra.pvm.session.PvmDbSession;

public class CheckVersion
implements Deployer {
    private static final Log LOG = Log.getLog(CheckVersion.class.getName());
    protected boolean assign = true;

    public void deploy(Deployment deployment) {
        ProcessDefinitionImpl processDefinition = (ProcessDefinitionImpl)deployment.getProcessDefinition();
        String name = processDefinition.getName();
        if (name == null) {
            throw new PvmException("process must have a name to deploy it");
        }
        int version = processDefinition.getVersion();
        if (version == -1 && !this.assign) {
            throw new PvmException("no version specified in process definition " + name);
        }
        Environment environment = Environment.getCurrent();
        if (environment == null) {
            throw new PvmException("environment is required by deployer check-version");
        }
        PvmDbSession pvmDbSession = environment.get(PvmDbSession.class);
        if (pvmDbSession == null) {
            throw new PvmException(PvmDbSession.class.getName() + " is required in the environment by " + this.getClass().getName());
        }
        if (version == -1 && this.assign) {
            ClientProcessDefinition latestDeployedVersion = pvmDbSession.findLatestProcessDefinitionByName(name);
            version = latestDeployedVersion != null ? latestDeployedVersion.getVersion() + 1 : 1;
            LOG.debug("assigning version " + version + " to process definition " + name);
            processDefinition.setVersion(version);
        } else if (pvmDbSession.findProcessDefinitionByName(name, version) != null) {
            throw new PvmException("process '" + name + "' version " + version + " already exists");
        }
    }
}

