/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.ejb;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.env.PvmEnvironmentFactory;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandExecutorSLSB
implements SessionBean {
    private SessionContext sessionContext;
    private EnvironmentFactory environmentFactory;
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(CommandExecutorSLSB.class.getName());

    public <T> T execute(Command<T> command) {
        Environment environment = this.environmentFactory.openEnvironment();
        try {
            LOG.debug("executing command " + command);
            T t = command.execute(environment);
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("failed to execute command " + command, e);
        }
        finally {
            environment.close();
        }
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void ejbCreate() throws CreateException {
        block8: {
            String envFactoryName = "java:orchestra/EnvironmentFactory";
            try {
                InitialContext initial = new InitialContext();
                try {
                    envFactoryName = (String)initial.lookup("java:comp/env/EnvironmentFactoryName");
                }
                catch (NameNotFoundException e) {
                    LOG.debug("environment factory name not set, using default: " + envFactoryName);
                }
                try {
                    Object namedObject = initial.lookup(envFactoryName);
                    if (namedObject instanceof EnvironmentFactory) {
                        LOG.debug("using environment factory at " + envFactoryName);
                        this.environmentFactory = (EnvironmentFactory)namedObject;
                        break block8;
                    }
                    if (namedObject == null || CommandExecutorSLSB.isInstance(EnvironmentFactory.class.getName(), namedObject)) {
                        LOG.debug("object bound to " + envFactoryName + " is a stale object factory, or null; unbinding it");
                        initial.unbind(envFactoryName);
                        this.environmentFactory = CommandExecutorSLSB.parseConfig(CommandExecutorSLSB.getConfigResource(initial));
                        CommandExecutorSLSB.bind(initial, this.environmentFactory, envFactoryName);
                        break block8;
                    }
                    LOG.debug("object bound to " + envFactoryName + " is not an environment factory, building one");
                    this.environmentFactory = CommandExecutorSLSB.parseConfig(CommandExecutorSLSB.getConfigResource(initial));
                }
                catch (NameNotFoundException noEnv) {
                    LOG.debug("environment factory not found at " + envFactoryName + ", building it");
                    this.environmentFactory = CommandExecutorSLSB.parseConfig(CommandExecutorSLSB.getConfigResource(initial));
                    CommandExecutorSLSB.bind(initial, this.environmentFactory, envFactoryName);
                }
            }
            catch (NamingException e) {
                LOG.error("could not create command executor", e);
                throw new CreateException("jndi access failed");
            }
        }
    }

    private static boolean isInstance(String className, Object object) {
        for (Class<?> cl = object.getClass(); cl != Object.class; cl = cl.getSuperclass()) {
            if (!cl.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    private static String getConfigResource(Context context) throws NamingException {
        String resource = "enterprise.environment.cfg.xml";
        try {
            resource = (String)context.lookup("java:comp/env/ConfigurationResource");
        }
        catch (NameNotFoundException e) {
            LOG.debug("configuration resource not set, using default: " + resource);
        }
        return resource;
    }

    private static EnvironmentFactory parseConfig(String resource) {
        LOG.debug("parsing configuration from " + resource);
        return new PvmEnvironmentFactory(resource);
    }

    private static void bind(Context context, EnvironmentFactory environmentFactory, String name) {
        try {
            context.bind(name, (Object)environmentFactory);
            LOG.info("bound " + environmentFactory + " to " + name);
        }
        catch (NamingException e) {
            LOG.info("WARNING: environment factory binding failed", e);
        }
    }

    public void ejbRemove() {
        this.environmentFactory = null;
        this.sessionContext = null;
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }
}

