/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Date;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.jobexecutor.AbstractDispatcherThread;
import org.ow2.orchestra.pvm.internal.jobexecutor.DeadJobHandler;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.pvm.internal.jobexecutor.pvm.PvmJobExecutor;
import org.ow2.orchestra.pvm.internal.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJobExecutor
implements JobExecutor {
    protected static final Log LOG = Log.getLog(PvmJobExecutor.class.getName());
    private static final long serialVersionUID = 1L;
    protected CommandService commandService;
    protected String name = "JobExecutor-" + AbstractJobExecutor.getHostName();
    protected int idleMillis = 5000;
    protected int lockMillis = 1800000;
    protected Command<Collection<Long>> acquireJobsCommand;
    protected Command<Date> nextDueDateCommand;
    protected boolean isActive = false;
    protected DeadJobHandler deadJobHandler;

    @Override
    public abstract void stop(boolean var1);

    @Override
    public abstract void stop();

    @Override
    public abstract void start();

    protected static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    @Override
    public void jobWasAdded() {
        if (this.getDispatcherThread() != null && this.getDispatcherThread().isActive()) {
            this.getDispatcherThread().jobWasAdded();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getIdleMillis() {
        return this.idleMillis;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public int getLockMillis() {
        return this.lockMillis;
    }

    public CommandService getCommandExecutor() {
        return this.commandService;
    }

    public Command<Collection<Long>> getAcquireJobsCommand() {
        return this.acquireJobsCommand;
    }

    public Command<Date> getNextDueDateCommand() {
        return this.nextDueDateCommand;
    }

    public void setCommandExecutor(CommandService commandExecutor) {
        this.commandService = commandExecutor;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIdleInterval(int idleInterval) {
        this.idleMillis = idleInterval;
    }

    public void setMaxLockTime(int maxLockTime) {
        this.lockMillis = maxLockTime;
    }

    @Override
    public DeadJobHandler getDeadJobHandler() {
        return this.deadJobHandler;
    }

    public void setDeadJobHandler(DeadJobHandler deadJobHandler) {
        this.deadJobHandler = deadJobHandler;
    }

    protected abstract AbstractDispatcherThread getDispatcherThread();
}

