/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor.jdk;

import java.util.Collection;
import org.ow2.orchestra.pvm.internal.jobexecutor.AbstractDispatcherThread;
import org.ow2.orchestra.pvm.internal.jobexecutor.jdk.JdkJobExecutor;
import org.ow2.orchestra.pvm.internal.jobexecutor.jdk.JobExecutorTask;
import org.ow2.orchestra.pvm.internal.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkDispatcherThread
extends AbstractDispatcherThread {
    private static final Log LOG = Log.getLog(JdkDispatcherThread.class.getName());
    private final JdkJobExecutor jobExecutor;

    JdkDispatcherThread(JdkJobExecutor jobExecutor) {
        this(jobExecutor, "DispatcherThread");
    }

    JdkDispatcherThread(JdkJobExecutor jobExecutor, String name) {
        super(name);
        this.jobExecutor = jobExecutor;
    }

    @Override
    public JdkJobExecutor getJobExecutor() {
        return this.jobExecutor;
    }

    @Override
    protected void putAcquiredJobDbidsOnQueue(Collection<Long> acquiredJobDbids) {
        LOG.debug("pushing jobs on the queue " + acquiredJobDbids);
        this.jobExecutor.getExecutorService().submit(new JobExecutorTask(this.jobExecutor.getCommandExecutor(), acquiredJobDbids));
        LOG.trace("jobs " + acquiredJobDbids + " were put on the queue");
    }
}

