/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor.pvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.jobexecutor.AbstractJobExecutor;
import org.ow2.orchestra.pvm.internal.jobexecutor.AcquireJobsCmd;
import org.ow2.orchestra.pvm.internal.jobexecutor.GetNextDueDateCmd;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobHistoryEntry;
import org.ow2.orchestra.pvm.internal.jobexecutor.pvm.DispatcherThread;
import org.ow2.orchestra.pvm.internal.jobexecutor.pvm.JobExecutorThreadPool;
import org.ow2.orchestra.pvm.internal.jobexecutor.pvm.JobExecutorThreadPoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PvmJobExecutor
extends AbstractJobExecutor
implements JobExecutor {
    private int nbrOfThreads = 3;
    private int historySize = 200;
    private JobExecutorThreadPool threadPool;
    private DispatcherThread dispatcherThread = null;
    private BlockingQueue<Collection<Long>> jobDbidsQueue = null;
    private final List<JobHistoryEntry> history = new ArrayList<JobHistoryEntry>();

    @Override
    public synchronized void start() {
        if (this.commandService == null) {
            throw new PvmException("no command executor available in jobImpl executor");
        }
        if (!this.isActive) {
            this.acquireJobsCommand = new AcquireJobsCmd(this.getName(), this.getLockMillis());
            this.nextDueDateCommand = new GetNextDueDateCmd();
            this.jobDbidsQueue = new ArrayBlockingQueue<Collection<Long>>(this.nbrOfThreads, true);
            this.isActive = true;
            AbstractJobExecutor.LOG.trace("starting jobImpl executor threads for jobImpl executor '" + this.name + "'...");
            this.threadPool = JobExecutorThreadPoolFactory.getNewInstance(this);
            this.threadPool.start();
            AbstractJobExecutor.LOG.trace("starting dispatcher thread for jobImpl executor '" + this.name + "'...");
            this.dispatcherThread = new DispatcherThread(this);
            this.dispatcherThread.start();
        } else {
            AbstractJobExecutor.LOG.trace("ignoring start: jobImpl executor '" + this.name + "' is already started'");
        }
    }

    @Override
    public synchronized void stop() {
        this.stop(false);
    }

    @Override
    public synchronized void stop(boolean join) {
        AbstractJobExecutor.LOG.debug("stopping jobImpl executor");
        if (this.isActive) {
            this.isActive = false;
            this.dispatcherThread.deactivate(true);
            this.waitTillQueueEmpty();
            this.threadPool.stop(join);
        } else {
            AbstractJobExecutor.LOG.trace("ignoring stop: jobImpl executor '" + this.name + "' not started");
        }
    }

    protected void waitTillQueueEmpty() {
        while (!this.jobDbidsQueue.isEmpty()) {
            AbstractJobExecutor.LOG.trace("waiting for jobImpl-id-queue to become empty");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                AbstractJobExecutor.LOG.trace("waiting for jobImpl-id-queue to become empty got interrupted");
            }
        }
    }

    protected BlockingQueue<Collection<Long>> getJobDbidsQueue() {
        return this.jobDbidsQueue;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public int getNbrOfThreads() {
        return this.nbrOfThreads;
    }

    @Override
    public DispatcherThread getDispatcherThread() {
        return this.dispatcherThread;
    }

    public List<JobHistoryEntry> getHistory() {
        return this.history;
    }

    public void setNbrOfJobExecutorThreads(int nbrOfJobExecutorThreads) {
        this.nbrOfThreads = nbrOfJobExecutorThreads;
    }

    public void setHistoryMaxSize(int historyMaxSize) {
        this.historySize = historyMaxSize;
    }
}

