/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.model;

import javax.transaction.Synchronization;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.Transaction;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.model.ExceptionHandlerImpl;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.internal.model.ProcessElementImpl;
import org.ow2.orchestra.pvm.session.DbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerSynchronization
implements Synchronization,
Command<Object> {
    private final ExceptionHandlerImpl exceptionHandler;
    private static final long serialVersionUID = 1L;
    protected ExecutionImpl execution;
    protected ProcessElementImpl processElement;
    protected Exception exception;
    protected CommandService commandService;

    public ExceptionHandlerSynchronization(ExceptionHandlerImpl exceptionHandler, ExecutionImpl execution, Exception exception, ProcessElementImpl processElement, CommandService commandService) {
        this.exceptionHandler = exceptionHandler;
        this.execution = execution;
        this.exception = exception;
        this.commandService = commandService;
        this.processElement = processElement;
    }

    public void afterCompletion(int status) {
        if (status != 4) {
            ExceptionHandlerImpl.LOG.info("WARNING: no rollback after transactional exception handler. did you forget to rollback the transaction ?");
        }
        this.commandService.execute(this);
    }

    @Override
    public Object execute(Environment environment) {
        DbSession dbSession = environment.get(DbSession.class);
        if (dbSession == null) {
            throw new PvmException("no " + DbSession.class.getName() + " available in the environment for reloading the execution");
        }
        this.execution = dbSession.get(ExecutionImpl.class, this.execution.getDbid());
        this.exceptionHandler.executeHandler(this.execution, this.exception, this.processElement);
        return null;
    }

    public void beforeCompletion() {
    }

    public void register(Transaction transaction) {
        transaction.registerSynchronization(this);
    }
}

