/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.util;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.util.ArrayUtil;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ArgDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectUtil {
    private static Log log = Log.getLog(ReflectUtil.class.getName());

    private ReflectUtil() {
    }

    static ClassLoader resolveClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            log.trace("using provided classloader");
            return classLoader;
        }
        Environment environment = Environment.getCurrent();
        if (environment != null && (classLoader = environment.getClassLoader()) != null) {
            log.trace("using environment classloader");
            return classLoader;
        }
        log.trace("using context classloader");
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            classLoader = ReflectUtil.resolveClassLoader(classLoader);
            log.trace("loading class " + className);
            return classLoader.loadClass(className);
        }
        catch (NoClassDefFoundError e) {
            throw new PvmException("couldn't define class " + className, e);
        }
        catch (ClassNotFoundException e) {
            throw new PvmException("couldn't load class " + className, e);
        }
    }

    public static InputStream getResourceAsStream(ClassLoader classLoader, String resource) {
        classLoader = ReflectUtil.resolveClassLoader(classLoader);
        log.trace("getting resource as stream " + resource);
        return classLoader.getResourceAsStream(resource);
    }

    public static Enumeration<URL> getResources(ClassLoader classLoader, String resource) {
        classLoader = ReflectUtil.resolveClassLoader(classLoader);
        try {
            log.trace("getting resources " + resource);
            return classLoader.getResources(resource);
        }
        catch (Exception e) {
            throw new PvmException("couldn't get resources " + resource, e);
        }
    }

    public static URL getResource(ClassLoader classLoader, String resource) {
        classLoader = ReflectUtil.resolveClassLoader(classLoader);
        try {
            log.trace("getting resource " + resource);
            return classLoader.getResource(resource);
        }
        catch (Exception e) {
            throw new PvmException("couldn't get resources " + resource, e);
        }
    }

    public static Object instantiate(ClassLoader classLoader, String className) {
        Object newObject;
        try {
            classLoader = ReflectUtil.resolveClassLoader(classLoader);
            Class<?> clazz = ReflectUtil.loadClass(classLoader, className);
            log.trace("instantiating " + className);
            newObject = clazz.newInstance();
        }
        catch (Exception e) {
            throw new PvmException("couldn't instantiate " + className, e);
        }
        return newObject;
    }

    public static Class<?>[] loadClasses(ClassLoader classLoader, List<String> constructorArgTypeNames) {
        if (constructorArgTypeNames == null) {
            return null;
        }
        Class[] classes = new Class[constructorArgTypeNames.size()];
        for (int i = 0; i < constructorArgTypeNames.size(); ++i) {
            classLoader = ReflectUtil.resolveClassLoader(classLoader);
            classes[i] = ReflectUtil.loadClass(classLoader, constructorArgTypeNames.get(i));
        }
        return classes;
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?>[] parameterTypes) {
        Constructor<T> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(parameterTypes);
            if (log.isTraceEnabled()) {
                log.trace("found constructor " + clazz.getName() + "(" + ArrayUtil.toString(parameterTypes) + ")");
            }
        }
        catch (SecurityException e) {
            throw new PvmException("wasn't allowed to get constructor '" + clazz.getName() + "(" + ReflectUtil.getParameterTypesText(parameterTypes) + ")'", e);
        }
        catch (NoSuchMethodException e) {
            throw new PvmException("couldn't find constructor '" + clazz.getName() + "(" + ReflectUtil.getParameterTypesText(parameterTypes) + ")'", e);
        }
        return constructor;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        return ReflectUtil.getField(clazz, fieldName, clazz);
    }

    private static Field getField(Class<?> clazz, String fieldName, Class<?> original) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            log.trace("found field " + fieldName + " in " + clazz.getName());
        }
        catch (SecurityException e) {
            throw new PvmException("wasn't allowed to get field '" + clazz.getName() + "." + fieldName + "'", e);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectUtil.getField(clazz.getSuperclass(), fieldName, original);
            }
            throw new PvmException("couldn't find field '" + original.getName() + "." + fieldName + "'", e);
        }
        return field;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        return ReflectUtil.getMethod(clazz, methodName, parameterTypes, clazz);
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Class<?> original) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, parameterTypes);
            if (log.isTraceEnabled()) {
                log.trace("found method " + clazz.getName() + "." + methodName + "(" + ArrayUtil.toString(parameterTypes) + ")");
            }
        }
        catch (SecurityException e) {
            throw new PvmException("wasn't allowed to get method '" + clazz.getName() + "." + methodName + "(" + ReflectUtil.getParameterTypesText(parameterTypes) + ")'", e);
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectUtil.getMethod(clazz.getSuperclass(), methodName, parameterTypes, original);
            }
            throw new PvmException("couldn't find method '" + original.getName() + "." + methodName + "(" + ReflectUtil.getParameterTypesText(parameterTypes) + ")'", e);
        }
        return method;
    }

    private static String getParameterTypesText(Class<?>[] parameterTypes) {
        if (parameterTypes == null) {
            return "";
        }
        StringBuffer parametersTypeText = new StringBuffer();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            parametersTypeText.append(parameterType.getName());
            if (i == parameterTypes.length - 1) continue;
            parametersTypeText.append(", ");
        }
        return parametersTypeText.toString();
    }

    public static <T> T newInstance(Class<T> clazz) {
        return ReflectUtil.newInstance(clazz, null, null);
    }

    public static <T> T newInstance(Constructor<T> constructor) {
        return ReflectUtil.newInstance(null, constructor, null);
    }

    public static <T> T newInstance(Constructor<T> constructor, Object[] args) {
        return ReflectUtil.newInstance(null, constructor, args);
    }

    private static <T> T newInstance(Class<T> clazz, Constructor<T> constructor, Object[] args) {
        if (clazz == null && constructor == null) {
            throw new IllegalArgumentException("can't create new instance without clazz or constructor");
        }
        String className = null;
        try {
            log.trace("creating new instance for class '" + className + "' with args " + ArrayUtil.toString(args));
            if (constructor == null) {
                log.trace("getting default constructor");
                constructor = clazz.getConstructor(null);
            }
            className = constructor.getDeclaringClass().getName();
            if (!constructor.isAccessible()) {
                log.trace("making constructor accessible");
                constructor.setAccessible(true);
            }
            return constructor.newInstance(args);
        }
        catch (Throwable t) {
            throw new PvmException("couldn't construct new '" + className + "' with args " + ArrayUtil.toString(args), t);
        }
    }

    public static Object get(Field field, Object object) {
        if (field == null) {
            throw new NullPointerException("field is null");
        }
        try {
            Object value = field.get(object);
            log.trace("got value '" + value + "' from field '" + field.getName() + "'");
            return value;
        }
        catch (Exception e) {
            throw new PvmException("couldn't get '" + field.getName() + "'", e);
        }
    }

    public static void set(Field field, Object object, Object value) {
        if (field == null) {
            throw new NullPointerException("field is null");
        }
        try {
            log.trace("setting field '" + field.getName() + "' to value '" + value + "'");
            if (!field.isAccessible()) {
                log.trace("making field accessible");
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (Exception e) {
            throw new PvmException("couldn't set '" + field.getName() + "' to '" + value + "'", e);
        }
    }

    public static Object invoke(Method method, Object target, Object[] args) {
        if (method == null) {
            throw new PvmException("method is null");
        }
        try {
            log.trace("invoking '" + method.getName() + "' on '" + target + "' with " + ArrayUtil.toString(args));
            if (!method.isAccessible()) {
                log.trace("making method accessible");
                method.setAccessible(true);
            }
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new PvmException("couldn't invoke '" + method.getName() + "' with " + ArrayUtil.toString(args) + " on " + target + ": " + targetException.getMessage(), targetException);
        }
        catch (Exception e) {
            throw new PvmException("couldn't invoke '" + method.getName() + "' with " + ArrayUtil.toString(args) + " on " + target + ": " + e.getMessage(), e);
        }
    }

    public static Method findMethod(Class<?> clazz, String methodName, List<ArgDescriptor> argDescriptors, Object[] args) {
        Method[] candidates;
        log.trace("searching for method " + methodName + " in " + clazz.getName());
        for (Method candidate : candidates = clazz.getDeclaredMethods()) {
            if (!candidate.getName().equals(methodName) || !ReflectUtil.isArgumentMatch(candidate.getParameterTypes(), argDescriptors, args)) continue;
            if (log.isTraceEnabled()) {
                log.trace("found matching method " + clazz.getName() + "." + methodName);
            }
            return candidate;
        }
        if (clazz.getSuperclass() != null) {
            return ReflectUtil.findMethod(clazz.getSuperclass(), methodName, argDescriptors, args);
        }
        return null;
    }

    public static Constructor<?> findConstructor(Class<?> clazz, List<ArgDescriptor> argDescriptors, Object[] args) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
            if (!ReflectUtil.isArgumentMatch(constructor.getParameterTypes(), argDescriptors, args)) continue;
            return constructor;
        }
        return null;
    }

    public static boolean isArgumentMatch(Class<?>[] parameterTypes, List<ArgDescriptor> argDescriptors, Object[] args) {
        int nbrOfArgs = 0;
        if (args != null) {
            nbrOfArgs = args.length;
        }
        int nbrOfParameterTypes = 0;
        if (parameterTypes != null) {
            nbrOfParameterTypes = parameterTypes.length;
        }
        if (nbrOfArgs == 0 && nbrOfParameterTypes == 0) {
            return true;
        }
        if (nbrOfArgs != nbrOfParameterTypes) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            String argTypeName;
            Class<?> parameterType = parameterTypes[i];
            String string = argTypeName = argDescriptors != null ? argDescriptors.get(i).getTypeName() : null;
            if (!(argTypeName != null ? !argTypeName.equals(parameterType.getName()) : args[i] != null && !parameterType.isAssignableFrom(args[i].getClass()))) continue;
            return false;
        }
        return true;
    }

    public static String getSignature(String methodName, List<ArgDescriptor> argDescriptors, Object[] args) {
        String signature = methodName + "(";
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ArgDescriptor argDescriptor;
                String argType = null;
                if (argDescriptors != null && (argDescriptor = argDescriptors.get(i)) != null && argDescriptor.getTypeName() != null) {
                    argType = argDescriptor.getTypeName();
                }
                if (argType == null && args[i] != null) {
                    argType = args[i].getClass().getName();
                }
                signature = signature + argType;
                if (i >= args.length - 1) continue;
                signature = signature + ", ";
            }
        }
        signature = signature + ")";
        return signature;
    }

    public static String getUnqualifiedClassName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ReflectUtil.getUnqualifiedClassName(clazz.getSimpleName());
    }

    public static String getUnqualifiedClassName(String className) {
        if (className == null) {
            return null;
        }
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex != -1) {
            className = className.substring(dotIndex + 1);
        }
        return className;
    }
}

