/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.binding;

import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.binding.WireOperationBinding;
import org.ow2.orchestra.pvm.internal.wire.operation.PropertyOperation;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertyBinding
extends WireOperationBinding {
    public PropertyBinding() {
        super("property");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        PropertyOperation propertyOperation = new PropertyOperation();
        if (element.hasAttribute("setter")) {
            propertyOperation.setSetterName(element.getAttribute("setter"));
        } else if (element.hasAttribute("name")) {
            propertyOperation.setPropertyName(element.getAttribute("name"));
        } else {
            parse.addProblem("property must have name or setter attribute: " + XmlUtil.toString((Node)element));
        }
        Element descriptorElement = XmlUtil.element((Element)element);
        if (descriptorElement != null) {
            Descriptor descriptor = (Descriptor)parser.parseElement(descriptorElement, parse, "descriptor");
            if (descriptor != null) {
                propertyOperation.setDescriptor(descriptor);
            } else {
                parse.addProblem("couldn't parse property content element as a value descriptor: " + XmlUtil.toString((Node)element));
            }
        } else {
            parse.addProblem("property must have 1 descriptor element out of " + parser.getBindings().getTagNames("descriptor") + " as content: " + XmlUtil.toString((Node)element));
        }
        return propertyOperation;
    }
}

