/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.binding;

import java.util.List;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.ow2.orchestra.pvm.internal.script.ScriptManager;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.wire.binding.WireDescriptorBinding;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ProvidedObjectDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.StringDescriptor;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class ScriptManagerBinding
extends WireDescriptorBinding {
    public ScriptManagerBinding() {
        super("script-manager");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        String defaultLanguage;
        ObjectDescriptor descriptor = new ObjectDescriptor(ScriptManager.class);
        if (element.hasAttribute("default-expression-language")) {
            defaultLanguage = element.getAttribute("default-expression-language");
            descriptor.addInjection("defaultExpressionLanguage", new StringDescriptor(defaultLanguage));
        }
        if (element.hasAttribute("default-script-language")) {
            defaultLanguage = element.getAttribute("default-script-language");
            descriptor.addInjection("defaultScriptLanguage", new StringDescriptor(defaultLanguage));
        }
        if (element.hasAttribute("read-contexts")) {
            String readContextsText = element.getAttribute("read-contexts");
            List readContextList = XmlUtil.parseCommaSeparatedList((String)readContextsText);
            String[] readContextNames = readContextList.toArray(new String[readContextList.size()]);
            descriptor.addInjection("readContextNames", new ProvidedObjectDescriptor(readContextNames));
        } else {
            parse.addProblem("'read-contexts' is a required attribute in element <script-manager />");
        }
        if (element.hasAttribute("write-context")) {
            String writeContextName = element.getAttribute("write-context");
            descriptor.addInjection("writeContextName", new StringDescriptor(writeContextName));
        } else {
            parse.addProblem("'write-context' is a required attribute in element <script-manager />");
        }
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        List scriptElements = XmlUtil.elements((Element)element, (String)"script-language");
        for (Element scriptElement : scriptElements) {
            String languageName = null;
            if (scriptElement.hasAttribute("name")) {
                languageName = scriptElement.getAttribute("name");
            } else {
                parse.addProblem("'name' is a required attribute in element <script-language />");
            }
            String factoryClassName = null;
            if (scriptElement.hasAttribute("factory")) {
                factoryClassName = scriptElement.getAttribute("factory");
            } else {
                parse.addProblem("'name' is a required attribute in element <script-language />");
            }
            if (languageName == null || factoryClassName == null) continue;
            try {
                Class<?> factoryClass = ReflectUtil.loadClass(parse.getClassLoader(), factoryClassName);
                ScriptEngineFactory scriptEngineFactory = (ScriptEngineFactory)factoryClass.newInstance();
                scriptEngineManager.registerEngineName(languageName, scriptEngineFactory);
            }
            catch (Exception e) {
                parse.addProblem("couldn't instantiate ScriptEngineFactory " + factoryClassName, e);
            }
        }
        descriptor.addInjection("scriptEngineManager", new ProvidedObjectDescriptor(scriptEngineManager));
        return descriptor;
    }
}

