/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.descriptor;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.hibernate.JDBCException;
import org.hibernate.cfg.Configuration;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.util.JDBCExceptionReporter;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireDefinition;
import org.ow2.orchestra.pvm.internal.wire.WireException;
import org.ow2.orchestra.pvm.internal.wire.descriptor.AbstractDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.PropertiesDescriptor;
import org.ow2.orchestra.pvm.internal.wire.operation.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateConfigurationDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(HibernateConfigurationDescriptor.class.getName());
    private String className;
    private String namingStrategyClassName;
    private List<Operation> mappingOperations;
    private List<Operation> cacheOperations;
    private PropertiesDescriptor propertiesDescriptor;
    private Operation schemaOperation;

    @Override
    public Object construct(WireContext wireContext) {
        Configuration configuration = null;
        if (this.className != null) {
            ClassLoader classLoader = wireContext.getClassLoader();
            LOG.trace("instantiating hibernate configation " + this.name + " with class " + this.className);
            Class<?> configurationClass = ReflectUtil.loadClass(classLoader, this.className);
            configuration = (Configuration)ReflectUtil.newInstance(configurationClass);
        } else {
            LOG.trace("instantiating default hibernate configuration  " + this.name);
            configuration = new Configuration();
        }
        return configuration;
    }

    @Override
    public void initialize(Object object, WireContext wireContext) {
        Configuration configuration = (Configuration)object;
        this.apply(this.mappingOperations, configuration, wireContext);
        this.apply(this.cacheOperations, configuration, wireContext);
        if (this.propertiesDescriptor != null) {
            Properties properties = (Properties)wireContext.create(this.propertiesDescriptor, false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("adding properties to hibernate configuration " + this.name + ": " + properties);
            }
            configuration.addProperties(properties);
        }
        if (this.schemaOperation != null) {
            this.schemaOperation.apply(configuration, wireContext);
        }
    }

    private void apply(List<Operation> operations, Configuration configuration, WireContext wireContext) {
        if (operations != null) {
            for (Operation operation : operations) {
                LOG.trace("hibernate configuration " + this.name + ": " + operation.toString());
                operation.apply(configuration, wireContext);
            }
        }
    }

    @Override
    public Class<?> getType(WireDefinition wireDefinition) {
        if (this.className != null) {
            try {
                return ReflectUtil.loadClass(wireDefinition.getClassLoader(), this.className);
            }
            catch (PvmException e) {
                throw new WireException("couldn't create hibernate configuration '" + this.className + "': " + e.getMessage(), e.getCause());
            }
        }
        return Configuration.class;
    }

    public void addMappingOperation(Operation operation) {
        if (this.mappingOperations == null) {
            this.mappingOperations = new ArrayList<Operation>();
        }
        this.mappingOperations.add(operation);
    }

    public void addCacheOperation(Operation operation) {
        if (this.cacheOperations == null) {
            this.cacheOperations = new ArrayList<Operation>();
        }
        this.cacheOperations.add(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<SQLException> executeScript(Connection connection, String[] script) throws SQLException {
        List<SQLException> exceptions = Collections.emptyList();
        Statement statement = connection.createStatement();
        try {
            for (String line : script) {
                LOG.debug(line);
                try {
                    statement.executeUpdate(line);
                    if (statement.getWarnings() == null) continue;
                    JDBCExceptionReporter.logAndClearWarnings((Connection)connection);
                }
                catch (SQLException e) {
                    if (exceptions.isEmpty()) {
                        exceptions = new ArrayList<SQLException>();
                    }
                    exceptions.add(e);
                }
            }
        }
        finally {
            statement.close();
        }
        return exceptions;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public PropertiesDescriptor getPropertiesDescriptor() {
        return this.propertiesDescriptor;
    }

    public void setPropertiesDescriptor(PropertiesDescriptor propertiesDescriptor) {
        this.propertiesDescriptor = propertiesDescriptor;
    }

    public String getNamingStrategyClassName() {
        return this.namingStrategyClassName;
    }

    public void setNamingStrategyClassName(String namingStrategyClassName) {
        this.namingStrategyClassName = namingStrategyClassName;
    }

    public Operation getSchemaOperation() {
        return this.schemaOperation;
    }

    public void setSchemaOperation(Operation schemaOperation) {
        this.schemaOperation = schemaOperation;
    }

    public static final class UpdateSchema
    implements Operation {
        private static final long serialVersionUID = 1L;
        private static final Operation INSTANCE = new UpdateSchema();

        private UpdateSchema() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            Properties cfgProperties = configuration.getProperties();
            Dialect dialect = Dialect.getDialect((Properties)cfgProperties);
            ConnectionProvider connectionProvider = ConnectionProviderFactory.newConnectionProvider((Properties)cfgProperties);
            try {
                Connection connection = connectionProvider.getConnection();
                try {
                    DatabaseMetadata metadata = new DatabaseMetadata(connection, dialect);
                    String[] updateScript = configuration.generateSchemaUpdateScript(dialect, metadata);
                    LOG.debug("updating db schema");
                    HibernateConfigurationDescriptor.executeScript(connection, updateScript);
                }
                finally {
                    connectionProvider.closeConnection(connection);
                }
            }
            catch (SQLException e) {
                throw new JDBCException("error updating schema", e);
            }
            finally {
                connectionProvider.close();
            }
        }

        public static Operation getInstance() {
            return INSTANCE;
        }
    }

    public static final class CreateSchema
    implements Operation {
        private static final long serialVersionUID = 1L;
        private static final Operation INSTANCE = new CreateSchema();

        private CreateSchema() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            Properties cfgProperties = configuration.getProperties();
            Dialect dialect = Dialect.getDialect((Properties)cfgProperties);
            ConnectionProvider connectionProvider = ConnectionProviderFactory.newConnectionProvider((Properties)cfgProperties);
            try {
                Connection connection = connectionProvider.getConnection();
                try {
                    LOG.debug("dropping db schema");
                    String[] dropScript = configuration.generateDropSchemaScript(dialect);
                    HibernateConfigurationDescriptor.executeScript(connection, dropScript);
                    LOG.debug("creating db schema");
                    String[] createScript = configuration.generateSchemaCreationScript(dialect);
                    HibernateConfigurationDescriptor.executeScript(connection, createScript);
                }
                finally {
                    connectionProvider.closeConnection(connection);
                }
            }
            catch (SQLException e) {
                throw new JDBCException("error creating schema", e);
            }
            finally {
                connectionProvider.close();
            }
        }

        public static Operation getInstance() {
            return INSTANCE;
        }
    }

    public static class SetCollectionCacheConcurrencyStrategy
    implements Operation {
        private static final long serialVersionUID = 1L;
        private final String collection;
        private final String concurrencyStrategy;

        public SetCollectionCacheConcurrencyStrategy(String collection, String concurrencyStrategy) {
            this.collection = collection;
            this.concurrencyStrategy = concurrencyStrategy;
        }

        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            configuration.setCollectionCacheConcurrencyStrategy(this.collection, this.concurrencyStrategy);
        }

        public String toString() {
            return "setting cache concurrency strategy on collection " + this.collection + " to " + this.concurrencyStrategy + " on hibernate configuration";
        }
    }

    public static class SetCacheConcurrencyStrategy
    implements Operation {
        private static final long serialVersionUID = 1L;
        private final String className;
        private final String concurrencyStrategy;

        public SetCacheConcurrencyStrategy(String className, String concurrencyStrategy) {
            this.className = className;
            this.concurrencyStrategy = concurrencyStrategy;
        }

        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            configuration.setCacheConcurrencyStrategy(this.className, this.concurrencyStrategy);
        }

        public String toString() {
            return "setting cache concurrency strategy on class " + this.className + " to " + this.concurrencyStrategy + " on hibernate configuration";
        }
    }

    public static class AddUrl
    implements Operation {
        private static final long serialVersionUID = 1L;
        private final String url;

        public AddUrl(String url) {
            this.url = url;
        }

        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            try {
                configuration.addURL(new URL(this.url));
            }
            catch (Exception e) {
                throw new PvmException("couldn't add hibernate mapping from URL " + this.url, e);
            }
        }
    }

    public static class AddClass
    implements Operation {
        private static final long serialVersionUID = 1L;
        private final String className;

        public AddClass(String className) {
            this.className = className;
        }

        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            try {
                Class<?> persistentClass = wireContext.getClassLoader().loadClass(this.className);
                configuration.addClass(persistentClass);
            }
            catch (Exception e) {
                throw new PvmException("couldn't add mapping for class " + this.className, e);
            }
        }

        public String toString() {
            return "adding persistent class " + this.className + " to hibernate configuration";
        }
    }

    public static class AddFile
    implements Operation {
        private static final long serialVersionUID = 1L;
        private final String fileName;

        public AddFile(String fileName) {
            this.fileName = fileName;
        }

        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            configuration.addFile(this.fileName);
        }

        public String toString() {
            return "adding hibernate mapping file " + this.fileName + " to configuration";
        }
    }

    public static class AddResource
    implements Operation {
        private static final long serialVersionUID = 1L;
        private final String resource;

        public AddResource(String resource) {
            this.resource = resource;
        }

        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            configuration.addResource(this.resource, wireContext.getClassLoader());
        }

        public String toString() {
            return "adding mapping resource " + this.resource + " to hibernate configuration";
        }
    }
}

