/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.descriptor;

import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.util.Listener;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireDefinition;
import org.ow2.orchestra.pvm.internal.wire.WireException;
import org.ow2.orchestra.pvm.internal.wire.descriptor.AbstractDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSessionFactoryDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(HibernateSessionFactoryDescriptor.class.getName());
    private String configurationName;
    private Descriptor configurationDescriptor;

    @Override
    public Object construct(WireContext wireContext) {
        Configuration configuration = null;
        configuration = this.configurationName != null ? (Configuration)wireContext.get(this.configurationName) : (this.configurationDescriptor != null ? (Configuration)wireContext.create(this.configurationDescriptor, false) : wireContext.get(Configuration.class));
        if (configuration == null) {
            throw new WireException("couldn't find configuration");
        }
        SessionFactory sessionFactory = configuration.buildSessionFactory();
        wireContext.addListener(new SessionFactoryCloser(sessionFactory));
        return sessionFactory;
    }

    @Override
    public Class<?> getType(WireDefinition wireDefinition) {
        return SessionFactory.class;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public void setConfigurationDescriptor(Descriptor configurationDescriptor) {
        this.configurationDescriptor = configurationDescriptor;
    }

    public static class SessionFactoryCloser
    implements Listener {
        private final SessionFactory sessionFactory;

        public SessionFactoryCloser(SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        public void event(Object source, String eventName, Object info) {
            if ("close".equals(eventName)) {
                LOG.trace("closing hibernate session factory");
                this.sessionFactory.close();
            }
        }
    }
}

