/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.descriptor;

import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.util.Listener;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ObjectDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExecutorDescriptor
extends ObjectDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(JobExecutorDescriptor.class.getName());
    private boolean autoStart = false;

    public JobExecutorDescriptor(Class<? extends JobExecutor> jobExecutorClass) {
        super(jobExecutorClass.getName());
    }

    @Override
    public Object construct(WireContext wireContext) {
        JobExecutor jobExecutor = (JobExecutor)super.construct(wireContext);
        if (this.autoStart) {
            wireContext.addListener(new JobExecutorStopper(jobExecutor));
        }
        return jobExecutor;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public static class JobExecutorStopper
    implements Listener {
        private final JobExecutor jobExecutor;

        public JobExecutorStopper(JobExecutor jobExecutor) {
            this.jobExecutor = jobExecutor;
        }

        public void event(Object source, String eventName, Object info) {
            if ("close".equals(eventName)) {
                LOG.trace("stopping jobExecutor");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new PvmException("exception while stopping JobExecutor");
                }
                this.jobExecutor.stop(true);
            }
        }
    }
}

