/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.descriptor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireException;
import org.ow2.orchestra.pvm.internal.wire.descriptor.CollectionDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapDescriptor
extends CollectionDescriptor {
    private static final long serialVersionUID = 1L;
    private List<Descriptor> keyDescriptors;

    public MapDescriptor() {
        super(HashMap.class.getName());
    }

    @Override
    public void initialize(Object object, WireContext wireContext) {
        Map map = (Map)object;
        try {
            if (this.keyDescriptors != null) {
                for (int i = 0; i < this.keyDescriptors.size(); ++i) {
                    Descriptor keyDescriptor = this.keyDescriptors.get(i);
                    Descriptor valueDescriptor = (Descriptor)this.valueDescriptors.get(i);
                    Object key = wireContext.create(keyDescriptor, true);
                    Object value = wireContext.create(valueDescriptor, true);
                    map.put(key, value);
                }
            }
        }
        catch (WireException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WireException("couldn't initialize object '" + (this.name != null ? this.name : this.className) + "'", e);
        }
    }

    public List<Descriptor> getKeyDescriptors() {
        return this.keyDescriptors;
    }

    public void setKeyDescriptors(List<Descriptor> keyDescriptors) {
        this.keyDescriptors = keyDescriptors;
    }
}

